% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coversim.R
\name{coversim}
\alias{coversim}
\title{Confidence Region Coverage}
\usage{
coversim(alpha, distn,
                n         = NULL,
                iter      = NULL,
                dataset   = NULL,
                point     = NULL,
                seed      = NULL,
                a         = NULL,
                b         = NULL,
                kappa     = NULL,
                lambda    = NULL,
                mu        = NULL,
                s         = NULL,
                sigma     = NULL,
                theta     = NULL,
                heuristic = 1,
                maxdeg    = 5,
                ellipse_n = 4,
                pts       = FALSE,
                mlelab    = TRUE,
                sf        = c(5, 5),
                mar       = c(4, 4.5, 2, 1.5),
                xlab      = "",
                ylab      = "",
                main      = "",
                xlas      = 0,
                ylas      = 0,
                origin    = FALSE,
                xlim      = NULL,
                ylim      = NULL,
                tol       = .Machine$double.eps ^ 1,
                info      = FALSE,
                returnsamp  = FALSE,
                returnquant = FALSE,
                repair    = TRUE,
                exact     = FALSE,
                showplot  = FALSE,
                delay     = 0 )
}
\arguments{
\item{alpha}{significance level; scalar or vector; resulting plot illustrates a 100(1 - \code{alpha})\% confidence region.}

\item{distn}{distribution to fit the dataset to; accepted values: \code{'cauchy'}, \code{'gamma'}, \code{'invgauss'},
\code{'logis'}, \code{'llogis'}, \code{'lnorm'}, \code{'norm'}, \code{'unif'}, \code{'weibull'}.}

\item{n}{trial sample size (producing each confidence region); scalar or vector; needed if a dataset is not given.}

\item{iter}{iterations (or replications) of individual trials per parameterization; needed if a dataset is not given.}

\item{dataset}{a \code{'n'} x \code{'iter'} matrix of dataset values, or a vector of length \code{'n'} (for a
single iteration).}

\item{point}{coverage is assessed relative to this point.}

\item{seed}{random number generator seed.}

\item{a}{distribution parameter (when applicable).}

\item{b}{distribution parameter (when applicable).}

\item{kappa}{distribution parameter (when applicable).}

\item{lambda}{distribution parameter (when applicable).}

\item{mu}{distribution parameter (when applicable).}

\item{s}{distribution parameter (when applicable).}

\item{sigma}{distribution parameter (when applicable).}

\item{theta}{distribution parameter (when applicable).}

\item{heuristic}{numeric value selecting method for plotting: 0 for elliptic-oriented point distribution, and
1 for smoothing boundary search heuristic.}

\item{maxdeg}{maximum angle tolerance between consecutive plot segments in degrees.}

\item{ellipse_n}{number of roughly equidistant confidence region points to plot using the
elliptic-oriented point distribution (must be a multiple of four because its algorithm
exploits symmetry in the quadrants of an ellipse).}

\item{pts}{displays confidence region boundary points if \code{TRUE} (applies to confidence region plots in which \code{showplot = TRUE}).}

\item{mlelab}{logical argument to include the maximum likelihood estimate coordinate point (default is \code{TRUE},
applies to confidence region plots when \code{showplot = TRUE}).}

\item{sf}{significant figures in axes labels specified using sf = c(x, y), where x and y represent the optional digits argument
in the R function \code{\link{round}} as it pertains the horizontal and vertical labels.}

\item{mar}{specifies margin values for \code{par(mar = c( ))} (see \code{mar} in \code{\link{par}}).}

\item{xlab}{string specifying the horizontal axis label (applies to confidence region plots when \code{showplot = TRUE}).}

\item{ylab}{string specifying the vertical axis label (applies to confidence region plots when \code{showplot = TRUE}).}

\item{main}{string specifying the plot title (applies to confidence region plots when \code{showplot = TRUE}).}

\item{xlas}{numeric in {0, 1, 2, 3} specifying the style of axis labels (see \code{las} in \code{\link{par}},
applies to confidence region plots when \code{showplot = TRUE}).}

\item{ylas}{numeric in {0, 1, 2, 3} specifying the style of axis labels (see \code{las} in \code{\link{par}},
applies to confidence region plots when \code{showplot = TRUE}).}

\item{origin}{logical argument to include the plot origin (applies to confidence region plots when \code{showplot = TRUE}).}

\item{xlim}{two element vector containing horizontal axis minimum and maximum values (applies to confidence region plots
when \code{showplot = TRUE}).}

\item{ylim}{two element vector containing vertical axis minimum and maximum values (applies to confidence region plots
when \code{showplot = TRUE}).}

\item{tol}{the \code{\link{uniroot}} parameter specifying its required accuracy.}

\item{info}{logical argument to return coverage information in a list; includes \code{alpha} value(s), \code{n} value(s), coverage
and error results per iteration, and \code{returnsamp} and/or \code{returnquant} when requested.}

\item{returnsamp}{logical argument; if \code{TRUE} returns random samples used in a matrix with \code{n} rows, \code{iter} cols.}

\item{returnquant}{logical argument; if \code{TRUE} returns random quantiles used in a matrix with \code{n} rows, \code{iter} cols.}

\item{repair}{logical argument to repair regions inaccessible using a radial angle from its MLE (multiple root azimuths).}

\item{exact}{logical argument specifying if alpha value is adjusted to compensate for negative coverage bias in order to achieve
(1 - alpha) coverage probability using previously recorded Monte Carlo simulation results; available for limited values of
alpha (roughly <= 0.2--0.3), n (typically n = 4, 5, ..., 50) and distributions (distn suffixes: weibull, llogis, norm).}

\item{showplot}{logical argument specifying if each coverage trial produces a plot.}

\item{delay}{numeric value of delay (in seconds) between trials so its plot can be seen (applies when \code{showplot = TRUE}).}
}
\value{
If the optional argument \code{info = TRUE} is included then a list of coverage results is returned.  That list
includes \code{alpha} value(s), \code{n} value(s), coverage and error results per iteration.  Additionally, \code{returnsamp = TRUE}
and/or \code{returnquant = TRUE} will result in an \code{n} row, \code{iter} column maxtix of sample and/or sample cdf values.
}
\description{
Creates a confidence region and determines coverage results for a corresponding point of interest.
Iterates through a user specified number of trials.
Each trial uses a random dataset with user-specified parameters (default) or a user specified dataset
matrix (\code{'n'} samples per column, \code{'iter'} columns) and returns the corresponding actual coverage results.
See the CRAN website https://CRAN.R-project.org/package=conf for a link to a \code{coversim} vignette.
}
\details{
Parameterizations for supported distributions are given following
the default axes convention in use by \code{crplot} and \code{coversim}, which are:

\tabular{lcc}{
\tab Horizontal \tab Vertical\cr
Distribution  \tab  Axis  \tab Axis\cr
Cauchy \tab \eqn{a} \tab \eqn{s}\cr
gamma \tab \eqn{\theta} \tab \eqn{\kappa}\cr
inverse Gaussian \tab \eqn{\mu} \tab \eqn{\lambda}\cr
log logistic \tab \eqn{\lambda} \tab \eqn{\kappa}\cr
log normal \tab \eqn{\mu} \tab \eqn{\sigma}\cr
logistic \tab \eqn{\mu} \tab \eqn{\sigma}\cr
normal \tab \eqn{\mu} \tab \eqn{\sigma}\cr
uniform \tab \eqn{a} \tab \eqn{b}\cr
Weibull \tab \eqn{\kappa} \tab \eqn{\lambda}
}

Each respective distribution is defined below.

\itemize{
\item The Cauchy distribution
for the real-numbered location parameter \eqn{a}, scale parameter \eqn{s}, and \eqn{x} is a real number,
has the probability density function
\deqn{1 / (s \pi (1 + ((x - a) / s) ^ 2)).}

\item The gamma distribution
for shape parameter \eqn{\kappa > 0}, scale parameter \eqn{\theta > 0}, and \eqn{x > 0},
has the probability density function
\deqn{1 / (Gamma(\kappa) \theta ^ \kappa) x ^ {(\kappa - 1)} exp(-x / \theta).}

\item The inverse Gaussian distribution
for mean \eqn{\mu > 0}, shape parameter \eqn{\lambda > 0}, and \eqn{x > 0},
has the probability density function
\deqn{\sqrt (\lambda / (2 \pi x ^ 3)) exp( - \lambda (x - \mu) ^ 2 / (2 \mu ^ 2 x)).}

\item The log logistic distribution
for scale parameter \eqn{\lambda > 0}, shape parameter \eqn{\kappa > 0}, and \eqn{x \ge 0},
has a probability density function
\deqn{(\kappa \lambda) (x \lambda) ^ {(\kappa - 1)} / (1 + (\lambda x) ^ \kappa) ^ 2.}

\item The log normal distribution
for the real-numbered mean \eqn{\mu} of the logarithm, standard deviation \eqn{\sigma > 0}
of the logarithm, and \eqn{x > 0},
has the probability density function
\deqn{1 / (x \sigma \sqrt(2 \pi)) exp(-(\log x - \mu) ^ 2 / (2 \sigma ^ 2)).}

\item The logistic distribution
for the real-numbered location parameter \eqn{\mu}, scale parameter \eqn{\sigma}, and \eqn{x} is a real number,
has the probability density function
\deqn{(1 / \sigma) exp((x - \mu) / \sigma) (1 + exp((x - \mu) / \sigma)) ^ {-2}}

\item The normal distribution
for the real-numbered mean \eqn{\mu}, standard deviation \eqn{\sigma > 0}, and \eqn{x} is a real number,
has the probability density function
\deqn{1 / \sqrt (2 \pi \sigma ^ 2) exp(-(x - \mu) ^ 2 / (2 \sigma ^ 2)).}

\item The uniform distribution for real-valued parameters \eqn{a} and \eqn{b} where \eqn{a < b}
and \eqn{a \le x \le b},
has the probability density function
\deqn{1 / (b - a).}

\item The Weibull distribution
for scale parameter \eqn{\lambda > 0}, shape parameter \eqn{\kappa > 0}, and \eqn{x > 0},
has the probability density function
\deqn{\kappa (\lambda ^ \kappa) x ^ {(\kappa - 1)} exp(-(\lambda x) ^ \kappa).}
}
}
\examples{
## assess actual coverage at various alpha = {0.5, 0.1} given n = 30 samples,  completing
## 10 trials per parameterization (iter) for a normal(mean = 2, sd = 3) rv
coversim(alpha = c(0.5, 0.1), "norm", n = 30, iter = 10, mu = 2, sigma = 3)

## show plots for 5 iterations of 30 samples each from a Weibull(2, 3)
coversim(0.5, "weibull", n = 30, iter = 5, lambda = 1.5, kappa = 0.5, showplot = TRUE,
origin = TRUE)

}
\references{
Weld, C., Loh, A., Leemis, L. (in press), "Plotting Likelihood-Ratio Based Confidence Regions for
Two-Parameter Univariate Probability Models", The American Statistician.
}
\seealso{
\code{\link{crplot}}, \code{\link{uniroot}}
}
\author{
Christopher Weld (\email{ceweld@email.wm.edu})

Lawrence Leemis (\email{leemis@math.wm.edu})
}
\concept{confidence region plot graphics visualization coverage parameter estimation}
\keyword{distribution}
\keyword{models}
\keyword{univar}
