% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_sd.R
\name{ci_sd}
\alias{ci_sd}
\title{Confidence Interval for the Population Standard Deviation}
\usage{
ci_sd(
  x,
  probs = c(0.025, 0.975),
  type = c("chi-squared", "bootstrap"),
  boot_type = c("bca", "perc", "stud", "norm", "basic"),
  R = 9999,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Error probabilites. The default c(0.025, 0.975) gives a symmetric 95\% confidence interval.}

\item{type}{Type of confidence interval. One of "chi-squared" (default) or "bootstrap".}

\item{boot_type}{Type of bootstrap confidence interval ("bca", "perc", "stud", "norm", "basic"). Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{boot::boot}.}
}
\value{
A list with class \code{cint} containing these components:
\itemize{
\item \code{parameter}: The parameter in question.
\item \code{interval}: The confidence interval for the parameter.
\item \code{estimate}: The estimate for the parameter.
\item \code{probs}: A vector of error probabilities.
\item \code{type}: The type of the interval.
\item \code{info}: An additional description text for the interval.
}
}
\description{
This function calculates confidence intervals for the population standard deviation. They are derived by calculating confidence intervals for the variance and then taking the square-root. For details, see \code{\link{ci_var}}.
}
\examples{
x <- 1:100
sd(x)
ci_sd(x)
sqrt(ci_var(x)$interval)
ci_sd(x, type = "bootstrap", R = 999)
}
\seealso{
\code{\link{ci_var}}.
}
