% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_scale.R
\name{ci_sd}
\alias{ci_sd}
\title{CI for the Population Std}
\usage{
ci_sd(
  x,
  probs = c(0.025, 0.975),
  type = c("chi-squared", "bootstrap"),
  boot_type = c("bca", "perc", "stud", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}

\item{type}{Type of CI. One of \code{"chi-squared"} (default)
or \code{"bootstrap"}.}

\item{boot_type}{Type of bootstrap CI ("bca", "perc", "stud", "norm", "basic").
Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{boot::boot()}.}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates CIs for the population standard deviation.
They are derived from CIs for the variance by taking the square-root.
For details, see \code{\link{ci_var}}.
}
\examples{
x <- 1:100
ci_sd(x)
ci_sd(x, type = "bootstrap", R = 999)  # Use larger R
}
\seealso{
\code{\link{ci_var}}.
}
