% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prefer.R
\name{conflict_prefer}
\alias{conflict_prefer}
\title{Persistently prefer one function over another}
\usage{
conflict_prefer(name, winner, losers = NULL, quiet = FALSE)
}
\arguments{
\item{name}{Name of function.}

\item{winner}{Name of package that should win the conflict.}

\item{losers}{Optional vector of packages that should lose the conflict.
If omitted, \code{winner} will beat all comers.}

\item{quiet}{If \code{TRUE}, all output will be suppressed}
}
\description{
\code{conflict_prefer()} allows you to declare "winners" of conflicts.
You can either declare a specific pairing (i.e. \code{dplyr::filter()} beats
\code{base::filter()}), or an overall winner (i.e. \code{dplyr::filter()} beats
all comers).
}
\section{Best practices}{

I recommend placing calls to \code{conflict_prefer()} at the top of your
script, immediately underneath the relevant \code{library()} call.
}

\examples{
# Prefer over all other packages
conflict_prefer("filter", "dplyr")

# Prefer over specified package or packages
conflict_prefer("filter", "dplyr", "base")
conflict_prefer("filter", "dplyr", c("base", "filtration"))
}
