% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{deploy_repo}
\alias{deploy_repo}
\alias{deploy_repo_enable}
\alias{deploy_repo_update}
\title{Deploy a Git Repository}
\usage{
deploy_repo(
  client,
  repository,
  branch,
  subdirectory,
  name = create_random_name(),
  title = name,
  ...
)

deploy_repo_enable(content, enabled = TRUE)

deploy_repo_update(content)
}
\arguments{
\item{client}{A Connect R6 object}

\item{repository}{The git repository to deploy}

\item{branch}{The git branch to deploy}

\item{subdirectory}{The subdirectory to deploy (must contain a \code{manifest.json})}

\item{name}{The "name" / unique identifier for the content. Defaults to a random character string}

\item{title}{The "title" of the content}

\item{...}{Additional options for defining / specifying content attributes}

\item{content}{An R6 Content object (i.e. the result of \code{content_item()})}

\item{enabled}{Whether Connect will enable automatic polling for repository updates}
}
\value{
A ContentTask object, for use with \code{poll_task()} (if you want to follow the logs)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Deploy a git repository directly to Posit Connect,
using Posit Connect's "pull-based" "git-polling" method of deployment.
}
\details{
\itemize{
\item \code{deploy_repo_enable()} enables (or disables) Posit Connect's git polling for a piece of content
\item \code{deploy_repo_update()} triggers an update of the content from its git
repository, if any are present
}
}
\seealso{
connectapi::poll_task, connectapi::repo_check_branches, connectapi::repo_check_manifest_dirs

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{dashboard_url_chr}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
