% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_close.R
\name{connection_close}
\alias{connection_close}
\title{Close a connection}
\usage{
connection_close(con, host = "", type = "", leave_open = FALSE)
}
\arguments{
\item{con}{Connection variable}

\item{host}{Host name of the connection. Optional, defaults to empty}

\item{type}{Type of connection. Optional, defaults to empty}

\item{leave_open}{Should the connection be left open. Defaults to FALSE}
}
\value{
Returns a NULL object. If using the RStudio IDE, it will attempt to close the
connection identified by the `host` and `type` arguments, or the con object
}
\description{
Close a connection
}
\examples{
library(DBI)
con <- connection_open(RSQLite::SQLite(), path = ":dbname:")
connection_close(con)
con
}
