% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{content}
\alias{content}
\title{Get Content Items}
\usage{
content(client, unpublished = FALSE)
}
\arguments{
\item{client}{A Client object (see \code{connect})}

\item{unpublished}{A boolean value specifying whether to return content that
has not successfully published}
}
\value{
A data frame (tibble) of content items

\itemize{
\item id - Auto-incrementing identifier for each content item (legacy)
\item guid - Unique identifier for each content item (preferred)
\item app_mode - The type of the content item (examples: \code{shiny},
\code{rmd-static}, \code{static}, \code{python-dash}, etc.)
\item content_category - For \code{static} app modes, the specific category
of content (examples: \code{site}, \code{plot}, \code{pin}, etc.)
\item name - The name of the content item as set at initial publishing
\item title - The user-provided title of the content item
\item description - The user-provided description of the content item
\item url - The URL to the content item
\item owner_guid - Unique identifier of the owner of the content item
\item owner_username - Username of the owner of the content item
\item owner_first_name - First name of the owner of the content item
\item owner_last_name - Last name of the owner of the content item
\item tags - A data frame of the tags associated with the content item,
with format: (id, name, parent_id, created_time, updated_time)
\item created_time - The timestamp at which the content item
was created
\item updated_time - The timestamp at which the content item
was last updated
}
}
\description{
Returns content items as a data frame from the Connect server. It will only
return content that is visible to the API key's user account.
}
