% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_change.R
\name{value_change}
\alias{value_change}
\title{Identify changes in a value over time}
\usage{
value_change(data, value, direction = c("all", "up", "down"), window_hours,
  join_key, time_var, value_var, mult = c("all", "first", "last"))
}
\arguments{
\item{data}{A time series data frame that includes the columns 'join_key',
'time_var', and 'value_var'}

\item{value}{A numeric value specifying the magnitude of change to identify}

\item{direction}{A string value specifying whether to identify changes in
the value up (an increase), down (a decrease), or all (both). The default
value is all.}

\item{window_hours}{A numeric value specifying the number of hours to search
for the value change}

\item{join_key}{A string name of the column to join the time series data
frame to itself. In other words, the primary key to the 'data' argument.}

\item{time_var}{A string name of the time stamp column in the time series
data frame}

\item{value_var}{A string name of the value variable column in the time
series data frame}

\item{mult}{A string specifying whether to return the first, last, or all
instance(s) of the value change with a default value of all}
}
\value{
A data.frame, data.table with time stamps of value changes over time
 along with values and time stamps for prior measurements
}
\description{
A function that reads in a time series data frame along with a specified
 value change and identifies instances where the value change occurs.
The user must specify the number of hours over which the value change must
 take place, the magnitude and direction of the value change, a variable to
 use to join the table to itself, the time stamp variable, and the value
 variable. The user must also specify whether to keep all instances that
 the value change occurs, or only the first or last instance.
This function must be used carefully, because certain types of arguments
 will cause the function to output a data frame with nrow(data)^2, where
 'data' is the input data. More specifically, if the user is trying to
 detect small variations in a value over a large period of time, the size
 of input 'data' should be limited.
}
\section{Imported functions}{

fastPOSIXct() from fasttime package, foverlaps() from data.table and
 general data.table syntax
}

\section{Errors}{

This function returns errors for:
\itemize{
 \item missing arguments (no arguments have defaults)
 \item passing an invalid direction or mult value
 \item passing arguments with invalid classes (data must be a data frame,
   value must be numeric, and window_hours must be numeric)
 \item passing join_key, time_var, or value_var values that are not column
   names in input data frames
}
}

\examples{
library(data.table)
systolic_bp <- as.data.table(vitals[VARIABLE == "SYSTOLIC_BP"])

# Identify all instances of a drop of 40 over 6 hours
value_change(systolic_bp, value = 40, direction = "down", window_hours = 6,
 join_key = "PAT_ID", time_var = "RECORDED_TIME",
 value_var = "VALUE", mult = "all")
# Identify first instance of a drop of 40 over 6 hours
value_change(systolic_bp, value = 40, direction = "down", window_hours = 6,
 join_key = "PAT_ID", time_var = "RECORDED_TIME",
 value_var = "VALUE", mult = "first")
# Identify last instance of a drop of 40 over 6 hours
value_change(systolic_bp, value = 40, direction = "down", window_hours = 6,
 join_key = "PAT_ID", time_var = "RECORDED_TIME",
 value_var = "VALUE", mult = "last")
# Identify all instances of drops and increases of 40 over 6 hours
value_change(systolic_bp, value = 40, direction = "all", window_hours = 6,
 join_key = "PAT_ID", time_var = "RECORDED_TIME",
 value_var = "VALUE", mult = "all")

}
