% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_reprex.R
\name{construct_reprex}
\alias{construct_reprex}
\title{construct_reprex}
\usage{
construct_reprex(n = 0, ...)
}
\arguments{
\item{n}{The number of steps to go up on the call stack}

\item{...}{Forwarded to \code{construct_multi()}}
}
\value{
Returns return \code{NULL} invisibly, called for side-effects.
}
\description{
\code{construct_reprex()} constructs all objects of the local environment,
or a caller environment \code{n} steps above. If \code{n > 0} the function call
is also included in a comment.
}
\details{
\code{construct_reprex()} doesn't call the \{reprex\} package but it shares
the purpose of making it easier to reproduce an output, hence the name.
If you want to it to look more like a \code{reprex::reprex} consider \code{options(constructive_print_mode = "reprex")}.
See \code{?constructive_print_mode} for more.

\code{construct_reprex()} wraps \code{construct_multi()} and is thus able to construct
unevaluated arguments using \code{delayedAssign()}. This means we can construct
reprexes for functions that use Non Standard Evaluation.

A useful trick is to use \code{construct_reprex()} with \code{options(error = recover)}
to be able to reproduce an error.

\code{construct_reprex()} might fail to reproduce the output of functions that refer
to environments other than their caller environment. We believe these are
very rare and that the simplicity is worth the rounded corners, but if you
encounter these limitations please do open a ticket on our issue tracker
at \verb{https://github.com/cynkra/constructive/} and we might expand the feature.
}
