% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-matrix.R
\name{opts_matrix}
\alias{opts_matrix}
\title{Constructive options for matrices}
\usage{
opts_matrix(constructor = c("matrix", "array", "next", "atomic"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment.}

\item{...}{Should not be used. Forces passing arguments by name.}
}
\value{
An object of class <constructive_options/constructive_options_environment>
}
\description{
Matrices are atomic vectors, lists, or objects of type \code{"expression"} with a \code{"dim"}
attributes of length 2.
}
\details{
Depending on \code{constructor}, we construct the environment as follows:
\itemize{
\item \code{"matrix"} : We use \code{matrix()}
\item \code{"array"} : We use \code{array()}
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried. This will usually
be equivalent to \code{"array"}
\item \code{"atomic"} : We define as an atomic vector and repair attributes
}
}
