% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-data.table.R
\name{opts_data.table}
\alias{opts_data.table}
\title{Constructive options for class 'data.table'}
\usage{
opts_data.table(
  constructor = c("data.table", "next", "list"),
  ...,
  selfref = FALSE
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object, see Details section.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{selfref}{Boolean. Whether to include the \code{.internal.selfref} attribute. It's
probably not useful, hence the default, \code{waldo::compare()} is used to assess the output
fidelity and doesn't check it, but if you really need to generate code that builds
an object \code{identical()} to the input you'll need to set this to \code{TRUE}.}
}
\value{
An object of class <constructive_options/constructive_options_data.table>
}
\description{
These options will be used on objects of class 'data.table'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"data.table"} (default): Wrap the column definitions in a \code{data.table()} call.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"list"} : Use \code{list()} and treat the class as a regular attribute.
}
}
