% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterator.R
\docType{class}
\name{Iterator}
\alias{Iterator}
\title{Iterator}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Iterator
}
\description{
An \code{\link[container]{Iterator}} is an object that
implements \code{get_next}, which is expected to return the next
element of the iterable object that it was created from.
}
\section{Iterator method/interface}{

\describe{
 \item{\code{get_next()}}{Return next element.}
 \item{\code{has_next()}}{Return TRUE if there is a next element.}
}
}

\examples{
# Iterator on primitive list
it <- Iterator$new(list("A", 1, 2))
while(it$has_next()) {
    print(it$get_next())
}
it$has_next()   # FALSE

# Iterator from Container object
d <- Deque$new(1:3)
it <- d$iter()
sum <- 0
while(it$has_next()) {
sum <- sum + it$get_next()
}
print(sum)
}
\seealso{
\code{\link[container]{Iterable}}, 
\code{\link[container]{Container}}, \code{\link[container]{Deque}}, 
\code{\link[container]{Set}}, and \code{\link[container]{Dict}}
}
\author{
Roman Pahl
}
\keyword{datasets}
