% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deque-S3.R
\name{dequeS3}
\alias{dequeS3}
\alias{deque}
\alias{as.deque}
\alias{is.deque}
\alias{addleft}
\alias{count}
\alias{peekleft}
\alias{popleft}
\alias{reverse}
\alias{rotate}
\title{Deque (double-ended queue) constructors}
\usage{
deque(x = list())

as.deque(x)

is.deque(x)

addleft(x, ...)

count(x, ...)

peekleft(x)

popleft(x)

reverse(x)

rotate(x, ...)
}
\arguments{
\item{x}{initial elements passed to constructor or object of class \code{Deque}
passed to member methods.}

\item{...}{further arguments}
}
\description{
Deques are a generalization of stacks and queues typically
with methods to add, remove and access elements at both sides of the
underlying data sequence. As such, \code{\link[container]{deque}} can also be
used to mimic both stacks and simple queues.
}
\details{
Inherits from \code{\link[container]{container}} and extends it by
\code{\link[container]{pop}} and \code{\link[container]{peek}} methods, element
\code{\link[container]{count}}ing, and \code{\link[container]{reverse}} and
 \code{\link[container]{rotate}} functionality.
}
\section{S3 methods for Deque objects}{

\describe{
 \item{\code{addleft(deq, elem)}}{Add \code{elem} to left side of the
 \code{deq}.}
 \item{\code{count(deq, elem)}}{Count number of \code{elem} occurences.}
 \item{\code{pop(deq)}}{Remove and return element from the right side of the
 \code{deq}.}
 \item{\code{popleft(deq)}}{Remove and return an element from the left side of
 the \code{deq}.}
 \item{\code{peek(deq)}}{Peek at last element on the right side without removing it.}
 \item{\code{peekleft(deq)}}{Peek at first element on the left side without
 removing it.}
 \item{\code{reverse(deq)}}{Reverse all elements of the \code{deq} in-place.}
 \item{\code{rotate(deq, n=1L)}}{Rotate the \code{deq} elements n steps to the
     right. If n is negative, rotate to the left.}
}
}

\examples{
# addleft
d <- 2 + deque(1L)
values(d)                                          # 2 1
values(3:1 + deque(0L))                 # 3 2 1 0

# count
count(deque(c("Lisa", "Bob", "Bob")), "Bob")     # 2

# peek and pop
d <- deque(1:3)
peek(d)                # 3
pop(d)                 # 3
pop(d)                 # 2
pop(d)                 # 1
\dontrun{
d$pop()              # Error: pop at empty Deque
}

d <- deque(1:3)
print(d)
reverse(d)   # 3 2 1
print(d)

rotate(d)
values(d)                           # 1 3 2
values(rotate(d, -1))               # 3 2 1
values(rotate(d, 2))               # 2 1 3
}
\seealso{
\code{\link[container]{container}}, \code{\link[container]{Deque}},
\code{\link[container]{+.Deque}}
}
