% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek_at2.R
\name{peek_at2}
\alias{peek_at2}
\alias{peek_at2.Container}
\alias{peek_at2.dict.table}
\title{Peek at Single Index}
\usage{
peek_at2(x, index, default = NULL)

\method{peek_at2}{Container}(x, index, default = NULL)

\method{peek_at2}{dict.table}(x, index, default = NULL)
}
\arguments{
\item{x}{an \code{R} object of the respective class.}

\item{index}{\code{character} name or \code{numeric} position of the sought value.}

\item{default}{value to be returned if peeked value does not exist.}
}
\value{
For \code{Container}, returns the value at the given index or (if not
found) the given default value.

For \code{dict.table}, returns the column named \code{index} if it exist
otherwise the given \code{default} value. If the default length does not match
the number of rows, it is recycled accordingly and a warning is given,
unless the default value has a length of 1, in which case recycling is
done silently.
}
\description{
Try to access element and return some default value if not found.
In contrast to \verb{[at2()]}, this function provides a less stricter element
access, that is, it remains valid even if peeked elements don't exist.
}
\examples{

# Container
co = container(a = 1, 2, b = 3, 4)
peek_at2(co, 1)
peek_at2(co, "a")
peek_at2(co, "x")
peek_at2(co, "x", default = 0)

# Dict
d = dict(a = 1, b = 1:3)
peek_at2(d, "b")
peek_at2(d, "x")
peek_at2(d, "x", default = 4:7)

# dict.table
dit = dict.table(a = 1:3, b = 4:6)
peek_at2(dit, "a")
peek_at2(dit, 1)
peek_at2(dit, 3)
peek_at2(dit, 3, default = 9)
peek_at2(dit, "x")
peek_at2(dit, "x", default = 0)
}
\seealso{
\code{\link[=at2]{at2()}} for strict element extraction
}
