% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_utility.R
\name{value_remaining}
\alias{value_remaining}
\title{Potential Value Remaining}
\usage{
value_remaining(x, n, alpha = 1, beta = 1, ndraws = 10000)
}
\arguments{
\item{x}{Vector of the number of successes per arm.}

\item{n}{Vector of the number of trials per arm.}

\item{alpha}{Shape parameter alpha for the prior beta distribution.}

\item{beta}{Shape parameter beta for the prior beta distribution.}

\item{ndraws}{Number of random draws from the posterior.}
}
\value{
Value_remaining distribution; the distribution of
improvement amounts that another arm might have over the current best arm.
}
\description{
Compute "value_remaining" in arms not
currently best in binomial bandits
}
\examples{

x <- c(10,20,30,80)
n <- c(100,102,120,240)
vr <- value_remaining(x, n)
hist(vr)

# "potential value" remaining in the experiment
potential_value <- quantile(vr, 0.95)

}
\author{
Thomas Lotze and Markus Loecher
}
