% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Newcombe_hybrid_score_CI_2x2.R
\name{Newcombe_hybrid_score_CI_2x2}
\alias{Newcombe_hybrid_score_CI_2x2}
\title{The Newcombe hybrid score confidence interval for the difference between probabilities}
\usage{
Newcombe_hybrid_score_CI_2x2(n, alpha = 0.05)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Newcombe hybrid score confidence interval for the difference between probabilities

Described in Chapter 4 "The 2x2 Table"
}
\examples{
# An RCT of high vs standard dose of epinephrine (Perondi et al., 2004)
Newcombe_hybrid_score_CI_2x2(perondi_2004)

# The association between CHRNA4 genotype and XFS (Ritland et al., 2007)
Newcombe_hybrid_score_CI_2x2(ritland_2007)

}
