% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull_github_limit}
\alias{pull_github_limit}
\title{Pull GitHub API limit for current user}
\usage{
pull_github_limit(.token = NULL)
}
\arguments{
\item{.token}{Authentication token.}
}
\value{
a \code{list}.
}
\description{
For unauthenticated requests, the rate limit allows for up to 60 requests per hour.
For API requests using Basic Authentication or OAuth, you can make up to 5000 requests per hour.
Here we use token to manage this.
Obtain a personal access token (PAT) from here: \url{https://github.com/settings/tokens}.
}
\details{
Typically, you can set \code{GITHUB_PAT} variable in your \code{.Renviron} file using the following format:

GITHUB_PAT=8c70fd8419398999c9ac5bacf3192882193cadf2

You can also set it in your \code{.Rprofile} file using the following format:

Sys.setenv(GITHUB_PAT="8c70fd8419398999c9ac5bacf3192882193cadf2")

For more on what to do with the PAT, see \link[gh:gh_whoami]{gh::gh_whoami}.
}
\examples{
pull_github_limit()
}
