% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/control_median_test.R
\name{control_median_test}
\alias{control_median_test}
\title{Median Comparison for Two-Sample Right-Censored Survival Data}
\usage{
control_median_test(t1, c1, t2, c2, R = 1000, seed = 1234)
}
\arguments{
\item{t1}{A vector of observed right-censored survival times for group 1 (Control).}

\item{c1}{A vector of censoring indicators for group 1 (0 = alive, 1 = dead).}

\item{t2}{A vector of observed right-censored survival times for group 2 (Treatment).}

\item{c2}{A vector of censoring indicators for group 2 (0 = alive, 1 = dead).}

\item{R}{Number of replications for bootstrapping (Default = 1000).}

\item{seed}{Seed number for bootstrapping (Default =  1234).}
}
\value{
A list containing the median survival times for both groups, Z-score, and two-sided p-value.
A plot of the two survival curves is also outputted.
}
\description{
Median Comparison for Two-Sample Right-Censored Survival Data
}
\details{
This function only compares the median between two samples. A general quantile version has not been developed yet. It is important to note the
possiblilty that the median survival time may not be estimable in our bootstrap samples. In such cases
the largest observed survival time will be considered as an estimate for the median survival time. Also,
if the median survival time for the control group is larger than the longest survival time for the
treatment group, then Q will be evaluated using the last observed survival time for the treatment group.
}
\examples{
#Reference: Klein and Moeschberger (1997) 
#Survival Analysis Techniques for Censored and Truncated Data, Springer.
#Data: Chapter 7.6 Example 7.9 (p. 211)

library(controlTest)
t1 <- c(1, 63, 105, 129, 182, 216, 250, 262, 301, 301,
       342, 354, 356, 358, 380, 383, 383, 338, 394, 408, 
       460, 489, 499, 523, 524, 535, 562, 569, 675, 676, 
       748, 778, 786, 797, 955, 968, 1000, 1245, 1271, 1420, 
       1551, 1694, 2363, 2754, 2950)
t2 <- c(17, 42, 44, 48, 60, 72, 74, 95, 103, 108, 122, 144, 
       167, 170, 183, 185, 193, 195, 197, 208, 234, 235, 254, 
       307, 315, 401, 445, 464, 484, 528, 542, 547, 577, 580, 
       795, 855, 1366, 1577, 2060, 2412, 2486, 2796, 2802, 2934, 2988)
c1 <- c(rep(1, 43), 0, 0)
c2 <- c(rep(1, 39), rep(0, 6))
control_median_test(t1, c1, t2, c2, R = 500)
}
\references{
Li, G., Tiwari, R.C., and Wells, M. (1996). "Quantile Comparison Functions in Two-Sample Problems: With Applications to Comparisons of Diagnostic Markers." Journal of the American Statistical Association, 91, 689-698.

Chakraborti, S., and Mukerjee, R. (1989), "A Confidence Interval for a Measure Associated With the Comparison of a Treatment With a Control," South African Statistical Journal, 23, 219-230.

Gastwirth, J. L., and Wang, J. L. (1988), "Control Percentile Test for Censored Data," Journal of Statistical Planning and Inference, 18, 267-276.
}

