% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_conv.R
\name{gamma_conv}
\alias{gamma_conv}
\title{Gamma convergence}
\usage{
gamma_conv(rawDat, ref = NA, last = NA, timeName = "time", printRanks = F)
}
\arguments{
\item{rawDat}{the tibble made by  times and countries.}

\item{ref}{the reference time, typically zero.}

\item{last}{the last time  to be considered.}

\item{timeName}{the name of the variable that contains time information.}

\item{printRanks}{logical flag for printing ranks based on data.}
}
\value{
gamma convergence  (indicated as KIt in Eurofound 2018 paper).
}
\description{
Given a dataframe (tibble) of times by countries indicator,
the gamma convergence is calculated. A time index is required.
Missing values are not allowed.
}
\examples{

# Example 1
# Dataframe in the format time by countries:
require(tibble)
myTB  <- tibble::tribble(
    ~years, ~UK, ~DE, ~IT,
    1990,   998,  1250, 332,
    1988,   1201, 868, 578,
    1989,   1150, 978, 682,
    1991,  1600,  1350, 802
    )

# Gamma convergence,  scrambled time and different time name:
resGamma <- gamma_conv(myTB,ref=1988, last=1991, timeName="years")

# Example 2
myTB1  <- tibble::tribble(
    ~time, ~UK, ~DE, ~IT,
    1990,   998,  1250, 332,
    1988,   1201, 868, 578,
    1989,   1150, 978, 682,
    1991,  1600,  1350, 802
    )
resGamma1 <- gamma_conv(myTB1, ref=1989,last=1990)

# Example 3
# Gamma convergence for the emp_20_64_MS Eurofound dataset:
data("emp_20_64_MS")

# check name of the time variable
names(emp_20_64_MS)
resGamma2<-gamma_conv(emp_20_64_MS,ref=2002,last=2005)
resGamma3<-gamma_conv(emp_20_64_MS,ref=2002,last=2018)
# Print also ranks based on data:
resGamma4<-gamma_conv(emp_20_64_MS,ref=2002,last=2018,printRanks=TRUE)

}
\references{
{ \url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
