% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_conv_graph.R
\name{sigma_conv_graph}
\alias{sigma_conv_graph}
\title{Graphical representation based on sigma convergence}
\usage{
sigma_conv_graph(
  sigmaconvOut,
  time_0 = NA,
  time_t = NA,
  aggregation = NA,
  x_angle = 45
)
}
\arguments{
\item{sigmaconvOut}{the output obtained from sigma_conv function.}

\item{time_0}{starting time.}

\item{time_t}{ending time.}

\item{aggregation}{the name of the set of member states for which the sigma-convergence is calculated.}

\item{x_angle}{axis orientation for time labels, default 45.}
}
\value{
a ggplot object to be displayed of saved using ggsave.
}
\description{
A ggplot of the standard deviation and the coefficient of variation based on the results obtained for sigma-convergence
}
\examples{

# Example 1
# Sigma convergence for the emp_20_64_MS Eurofound dataset in the period 2002-2006:
data(emp_20_64_MS)
reSigConv <- sigma_conv(emp_20_64_MS, timeName = "time", time_0 = 2002,time_t = 2006)

# Graphical plot based on the results for sigma-convergence
reSiggraph<-sigma_conv_graph(reSigConv,2002,2006,aggregation = 'EU27')

# Example 2
# Sigma-convergence for the emp_20_64_MS Eurofound dataset in the period 2008-2016:
reSigConv1 <- sigma_conv(emp_20_64_MS, timeName = "time", time_0 = 2008,time_t = 2016)

# Graphical plot based on the results for sigma-convergence
reSiggraph1<-sigma_conv_graph(reSigConv1,2008,2016,aggregation = 'EU27')

# Select different time windows, e.g. 2012-2016 and change x_angle:
reSiggraph2<-sigma_conv_graph(reSigConv1,2012,2016,aggregation = 'EU27', x_angle=90)

}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
