% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertGraph.R
\name{convertGraph}
\alias{convertGraph}
\title{Convert Graphical Files Format}
\usage{
convertGraph(from, to, size = 1.0, path = NULL)
}
\arguments{
\item{from}{The graphical source file}

\item{to}{The file name and extension of the converted file}

\item{size}{Enlarge the converted graphical file by magnifying its resolution with the given number}

\item{path}{Path to executable 'phantomJS' binary, downloadble from \url{http://phantomjs.org/download.html}}
}
\value{
Converts the given graphical file to the specified file format.
}
\description{
Converts graphical file formats (SVG, PNG, JPEG, BMP, GIF, PDF, etc) to one another. The exceptions are the SVG file format that can only be converted to other formats and in contrast, PDF format, which can only be created from others graphical formats. The main purpose of the package was to provide a solution for converting SVG file format to PNG which is often needed for exporting graphical files produced by R widgets.
}
\examples{
\dontrun{
#convert SVG to PNG
convertGraph("./example.svg", "./example.png", path = "path to executable phantomJS" )

#convert PNG to JPEG
convertGraph("./example.png", "./example.jpeg", path = "path to executable phantomJS" )

#convert JPEG to PDF
convertGraph("./example.jpeg", "./example.pdf", path = "path to executable phantomJS" )
}

}
\author{
E. F. Haghish \cr
Medical Informatics and Biostatistics (IMBI) \cr
University of Freiburg, Germany \cr
\email{haghish@imbi.uni-freiburg.de} \cr
\cr
Department of Mathematics and Computer Science \cr
University of Southern Denmark \cr
\email{haghish@imada.sdu.dk}
}
\keyword{BMP}
\keyword{GIF}
\keyword{JPEG}
\keyword{PDF}
\keyword{PNG}
\keyword{SVG}
\keyword{diagram}
\keyword{graphics}
\keyword{literate}
\keyword{plot}
\keyword{visualization}

