% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unexported.R
\name{.setBiomaRtCacheLocation}
\alias{.setBiomaRtCacheLocation}
\title{Unexported functions
Set the location for the biomaRt cache}
\usage{
.setBiomaRtCacheLocation(x = "")
}
\arguments{
\item{x}{(\code{character}). Optional user-defined path used as cache location. Defaults to "".}
}
\value{
A character vector with the BIOMART_CACHE location.
}
\description{
\command{.setBiomaRtCacheLocation()} determines and sets the cache location
used by the functions in the 'biomaRt' package and defined in the BIOMART_CACHE
environment variable.
If the system default cache location is under the user's home directory a sub-folder biomaRt is used.
If not and 'x' is an empty string (the default) and the variable is unset it will be set to
"~/.caches/biomaRt", which is the default location in Linux. The tilde will be
expanded to match the user's home directory.
If the variable has been set externally to a location under the user's home that path is returned.
}
\examples{
\dontrun{.setBiomaRtCacheLocation()}
}
\seealso{
\code{\link[rappdirs]{user_cache_dir}}, \code{\link[base]{Sys.getenv}}
}
\keyword{internal}
