% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooccurrence.R
\name{coocnet}
\alias{coocnet}
\title{coocnet}
\usage{
coocnet(dataFile = "", dataType = "protein", conservativeFilter = 0.95,
  cooccurFilter = NULL, networkFile = "cooccurNetwork", module = FALSE,
  moduleFile = "cooccurNetworkModule", property = FALSE,
  propertyFile = "cooccurNetworkProperty", siteCo = FALSE,
  siteCoFile = "siteCooccurr", sampleTimes = 100, debug = FALSE,
  parallel = FALSE, memory = NULL)
}
\arguments{
\item{dataFile}{character, a FASTA data file name with full path.}

\item{dataType}{character, 'protein' by default, the type of data will be processed. It could be 'DNA', 'RNA', 'protein', 'SNP' or 'other'.}

\item{conservativeFilter}{numeric, a number in the range of 0~1,  0.95 by default. It's used to filter the highly conservative columns which the ratio of some residue is larger than the conservationFilter.}

\item{cooccurFilter}{numeric, a number in the range of 0~1. It determines whether two columns are perfect co-occurrence. In default, for the data type of protein, it is set to be 0.9, while for the other data types, it is set to be 1.}

\item{networkFile}{character, 'cooccurNetwork' be default. It is a file name with full path for storing the co-occurrence network for each row.}

\item{module}{logic, FALSE by default, to check whether the modules in each network of the networkFile would be calculated.}

\item{moduleFile}{character, 'cooccurNetworkModule' by default. It is a file name with full path for storing the modules for co-occurrence network.}

\item{property}{logic, FALSE by default, to check whether the properties for each network of the networkFile, including the network diameter, connectivity, ConnectionEffcient and so on, would be calculated.}

\item{propertyFile}{character, 'cooccurNetworkProperty' by default. It is a file name with full path storing the properties for each network of the networkFile.}

\item{siteCo}{logic, FALSE by default, to check whether the residue co-occurence file would be calculated.}

\item{siteCoFile}{character, 'siteCooccurr' by default. It is a file name with full path for storing the RCOS between all pairs of columns, and the related p-values.}

\item{sampleTimes}{numeric, an integer of permutations in the simulation when calculating the p-values. It should be greater than 100.}

\item{debug}{logic, FALSE by default, indicates whether the debug message will be displayed or not.}

\item{parallel}{logic, FALSE by default. It only supports Unix/Mac (not Windows) system.}

\item{memory}{character, the type of matrix, NULL by default. It could be 'memory' or 'sparse'. If it's set to be 'memory', all data would be manipulated in the RAM by using normal matrix and package 'bigmemory'. If it's set to be 'sparse', the package "Matrix" would be used to manipulate massive matrices in memory and initialize huge sparse matrix, which could significantly reduce the RAM consumed. In default, it is set to be NULL, so that the system would determine automatically whether all data is manipulated in the RAM or not, according to the size of data inputted and the RAM available for R.}
}
\value{
list, all the output file paths are attributed in it. \cr  The attribute "networkFile" stores the co-occurrence network for each row; \cr The attribute "moduleFile" is optional. When the module is set to be TRUE, it would be output. It stores the modules for co-occurrence network; \cr The attribute "propertyFile" is optional. When the property is set to be TRUE, it would be output. It stores the properties for co-occurrence network; \cr The attribute "siteCoFile" is optional. When the property is set to be TRUE, it would be output. It stores all the pairwise siteCos between columns.
}
\description{
Read and preprocess data, and construct the co-occurrence network in one step.
}
\examples{
cooccurNetwork  = coocnet(dataFile=getexample(dataType="protein"), dataType="protein")
}
\references{
Du, X., Wang, Z., Wu, A., Song, L., Cao, Y., Hang, H., & Jiang, T. (2008). Networks of genomic co-occurrence capture characteristics of human influenza A (H3N2) evolution. Genome research, 18(1), 178-187. doi:10.1101/gr.6969007
}

