% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothfun.R
\name{smoothfun}
\alias{smoothfun}
\title{Smoothed Function}
\usage{
smoothfun(x, y = NULL, w = NULL, df = NULL, ...)
}
\arguments{
\item{x}{a vector giving the values of the predictor variable, or a list or a two-column matrix specifying x and y.}

\item{y}{responses. If y is missing or NULL, the responses are assumed to be specified by x, with x the index vector.}

\item{w}{optional vector of weights of the same length as x; defaults to all 1.}

\item{df}{the desired equivalent number of degrees of freedom. Must be in [2,nx], where nx is the number of unique x values. If not given, nx is set to the square root of the number of unique x-values.}

\item{...}{additional optional arguments used by \code{\link[stats]{smooth.spline}}.}
}
\value{
Returns a fast and vectorized smoothed function f(x).
}
\description{
Generates a cubic smoothed spline function y=f(x) approximating supplied (x,y)-data with a custom number of degrees of freedom. The routines builds on \code{\link[stats]{smooth.spline}}, but directly returns the smoothed function rather than the fitted model.
}
\examples{
# make random data set
set.seed(1)
x = runif(100)
y = sin(2*pi*x)+rnorm(100, sd=0.5)
plot(x,y,pch=16)

# smoothed spline
f = smoothfun(x, y)
curve(f, add=TRUE, col='red')

# smoothed spline with custom degree of freedom
g = smoothfun(x, y, df=5)
curve(g, add=TRUE, col='blue')

}
\seealso{
\code{\link[stats]{smooth.spline}}
}
\author{
Danail Obreschkow
}
