% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owenSet.R
\name{owenSet}
\alias{owenSet}
\title{Owen Set}
\usage{
owenSet(c, A, B, show.data = FALSE)
}
\arguments{
\item{c}{vector containing the benefits of the products.}

\item{A}{production matrix.}

\item{B}{matrix containing the amount of resources of the several players 
where each row is one player.}

\item{show.data}{logical value indicating if the function displays the 
console output (\code{TRUE}) or not (\code{FALSE}). By default the 
value is \code{FALSE}.}
}
\value{
\code{owenSet} returns and prints the owen Set of associated 
linear production problem.
}
\description{
This function computes the Owen Set of a linear production game
}
\examples{
# Vector of benefits
c <- c(68, 52)
# Production matrix
A <- matrix(c(4, 5, 6, 2), ncol=2, byrow = TRUE)
# Matrix of resources. Each row is the vector of resources of each player
B <- matrix(c(4, 6, 60, 33, 39, 0),ncol = 3, byrow = TRUE)
# Solution of the associated linear production game
owenSet(c, A, B, show.data = TRUE)

 # ------------------------------------------------------------------------
 # The linear production problem has a unique Owen's allocation:
 # ------------------------------------------------------------------------
 # [1] "(230, 282, 480)"
  
}
\author{
D. Prieto
}
