% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarsusie.R
\name{cophe.susie}
\alias{cophe.susie}
\title{run \code{cophe.susie} using susie to detect separate signals}
\usage{
cophe.susie(
  dataset,
  querysnpid,
  querytrait,
  p1 = 1e-04,
  p2 = 1e-04,
  p12 = 1e-05,
  pa = NULL,
  pc = NULL,
  susie.args = list()
)
}
\arguments{
\item{dataset}{\emph{either} a list with specifically named elements defining the dataset
to be analysed. (see
\link{check_dataset}), or the result of running \link{runsusie} on such a
dataset}

\item{querysnpid}{Id of the query variant}

\item{querytrait}{Query trait name}

\item{p1}{prior probability a SNP is associated with trait 1, default 1e-4 (coloc prior)}

\item{p2}{prior probability a SNP is associated with trait 2, default 1e-4 (coloc prior)}

\item{p12}{prior probability a SNP is associated with both traits, default 1e-5 (coloc prior)}

\item{pa}{prior probability that a non-query variant is causally associated with the query trait , default \eqn{pa = p2} (cophescan prior)}

\item{pc}{prior probability that the query variant is causally associated with the query trait, default \eqn{pc =  p12/p1+p12} (cophescan prior)}

\item{susie.args}{a named list of additional arguments to be passed to
\link{runsusie}}
}
\value{
a list, containing elements
\itemize{
\item summary a data.table of posterior
probabilities of each global hypothesis, one row per pairwise comparison
of signals from the two traits
\item results a data.table of detailed results giving the posterior probability
for each snp to be jointly causal for both traits \emph{assuming Hc is true}.
Please ignore this column if the corresponding posterior support for H4
is not high.
\item priors a vector of the priors used for the analysis
}
}
\description{
Check if a variant causally associated in one trait might be causal in another trait
}
\examples{
library(cophescan)
data(cophe_multi_trait_data)
query_trait_1 <- cophe_multi_trait_data$summ_stat[['Trait_1']]
querysnpid <- cophe_multi_trait_data$querysnpid
query_trait_1$LD <- cophe_multi_trait_data$LD
res.susie <- cophe.susie(query_trait_1, querysnpid = querysnpid, querytrait='Trait_1')
summary(res.susie)
}
\author{
Ichcha Manipur
}
