% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copre.R
\name{copre}
\alias{copre}
\title{Copula Resampling}
\usage{
copre(
  data,
  N,
  k,
  rho = 0.91,
  grd_res = 1000,
  nthreads = parallel::detectCores(),
  gpu = FALSE,
  gpu_path = NULL,
  gpu_odir = NULL,
  gpu_seed = 1234
)
}
\arguments{
\item{data}{The from which to sample predictive distributions.}

\item{N}{The number of unobserved data points to resample for each chain.}

\item{k}{The number of predictive distributions to sample.}

\item{rho}{A scalar concentration parameter.}

\item{grd_res}{The number of points on which to evaluate the predictive
distribution.}

\item{nthreads}{The number of threads to call for parallel execution.}

\item{gpu}{A logical value indicating whether or not to use the CUDA
implementation of the algorithm.}

\item{gpu_path}{The path to the CUDA implementation source code.}

\item{gpu_odir}{A directory to output the compiled CUDA code.}

\item{gpu_seed}{A seed for the CUDA random variates.}
}
\value{
A \code{copre_result} object, whose underlying structure is a list
 which contains the following components:
}
\description{
A function that samples predictive distributions for univariate
 continuous data using the bivariate gaussian copula.
}
\examples{
res_cop <- copre(rnorm(50), 10, 10, nthreads = 1)
}
\references{
Fong, E., Holmes, C., Walker, S. G. (2021). Martingale Posterior
 Distributions. arXiv. DOI: \doi{10.48550/arxiv.2103.15671}
}
