% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsurvival.R
\name{nsurvival}
\alias{nsurvival}
\title{Sample size calculation in clinical trials with one primary survival endpoint}
\usage{
nsurvival(design,Survhyp,alpha,duraccrual,durstudy,power,pe,look,fup,dropout,dqol)
}
\arguments{
\item{design}{Superiority=c(1,sided)[with sided=1 if 1-sided and 2 if 2-sided]; Non inferiority=c(2); Equivalence=c(3)}

\item{Survhyp}{For Superiority=c(thyp,t,hype,Sc); for Non inferiority=c(thyp,t,hype,Sc,hypeA); for Equivalence=c(t,delta,Sc): parameters at time t 
if thyp=1 then hype is survival rate in experimental arm under the null hypothesis and hypeA is the survival rate in the experimental arm under the alternative hypothesis; 
if thyp=2 then hype is the hazard ratio under the null hypothesis and hypeA is the hazard ratio under the alternative hypothesis; Sc is survival rate in the control arm; 
delta is the log hazard ratio equivalence margin. When endpoint is HRQoL, the survival rate is replaced by the rate of patients without HRQoL deterioration.}

\item{alpha}{Type I error, for Non inferiority, Equivalence and 1-sided superiority is a vector of length one. 
For 2-sided superiority is a vector to length two c(alpha.low, alpha.up).}

\item{duraccrual}{Accrual duration, expressed in number of days, months or years}

\item{durstudy}{Study duration, expressed in number of days, months or years}

\item{power}{1- Probability of a type II error. Default value=0.80.}

\item{pe}{Proportion (ratio) of patients assigned to the experimental arm (with 0<pe<1). Default value = 0.5.}

\item{look}{The number of interim analyses, c(1) for one final analysis; c(nb, bound, timing) for at least one interim analyses with bound=c(bound.eff,bound.fut):1-sided or bound=c(bound.lown,bound.up):2-sided.
nb the number of planned looks, bound.eff and bound.fut corresponds to the type of boundaries used for efficacy (i.e. reject H0) and futility (i.e. reject H1). 
bound.fut=0: No futility monitoring, 1: Lan deMets O.Brien Fleming, 2: Lan deMets Pocock. 
bound.low and bound.up the type of lower and upper boundaries used (1: Lan deMets O.Brien Fleming, 2: Lan deMets Pocock, 3: O.Brien Fleming, 4: Pocock). Default value = 1.}

\item{fup}{Follow-up information, No fixed:c(0) (follow-up until the end of study); 
Fixed:c(1, durfollow) with durfollow is the duration of follow-up. Default value = 0.}

\item{dropout}{Drop out information, No drop out=c(0); Drop out=c(1,gammae,gammac) with gammae the hazard drop out rates in experimental arm 
and control arm respectively. Default value = 0.}

\item{dqol}{number of targeted dimensions for the health related quality of life. Default value = 0.}
}
\value{
Event: number of events estimated

Total: number of patients

Ne: number for experimental arm for each endpoint

Nc: number for control arm for each endpoint

HR: Hazard ratio for each endpoint
}
\description{
nsurvival() is used to determine the sample size for one time to event endpoint, such as Overall Survival (OS), Progression Free Survival
or the health related quality of life (HRQoL). If it is HRQoL, several HRQoL dimension can be considered.
}
\details{
The nsurvival function computes the sample size for one time to event endpoint, such as OS, PFS or HRQoL. 
HRQoL has become increasingly important in clinical trials over the past two decades.
}
\examples{
#############################################################
###############  Design superiority:one-sided ###############
#############################################################
## 7-year survival rates Se=0.57 and Sc=0.53, alpha=0.05, accrual duration of 4 years, 
## study duration of 8 years and default values i.e power=0.80, pe=0.5, look=1, fup=0, 
## dropout=0, dqol=0
 
ns1 <- nsurvival(design=c(1,1),Survhyp=c(1,7,0.57,0.53),alpha=0.05,duraccrual=4,durstudy=8)

############################################################
############### Design superiority:two-sided ###############
############################################################
## 5-year rate without HRQoL deterioration Se=0.75 and Sc=0.65, alpha=c(0.04,0.01), accrual 
## duration of 2 years, study duration of 6 years, power=0.90, pe=0.55, follow-up 5 years, 
## 3 target variables for health related quality of life and default values i.e look=1, dropout=0

ns2 <- nsurvival(design=c(1,2),Survhyp=c(1,5,0.75,0.65),alpha=c(0.04,0.01),duraccrual=2,
durstudy=6,power=0.90,pe=0.55,fup=c(1,5),dqol=3)  

###########################################################
###############   Design non-inferiority ##################
###########################################################
## 5-year survival rates are equal under the alternative hypothesis, i.e Se=0.60 and Sc=SeA=0.70, 
## with alpha=0.05, accrual duration of 4 years, study duration of 8 years, two interim analysis 
## after the occurence 1/3 and 2/3 of the events and default values i.e power=0.80, pe=0.5, fup=0, 
## dropout=0, dqol=0 

ns3 <- nsurvival(design=c(2),Survhyp=c(1,5,0.60,0.70, 0.70),alpha=0.05,duraccrual=4,
durstudy=8,look=c(3,c(1,1),c(1/3,2/3)))

##########################################################
###############    Design superiority   ##################
##########################################################
## 3-year rate without HRQoL deterioration Sc=0.80 and log hazard equivalence margin delta=0.1 
## with alpha=0.10, accrual duration of 3 years, study duration of 5 years, drop out hazard rate 
## of 0.05 per arm, 2 target variables for health related quality of life and default values i.e 
## power=0.80, pe=0.5, look=1, fup=0

ns4 <- nsurvival(design=c(3),Survhyp=c(3,0.10,0.80),alpha=0.10,duraccrual=3,durstudy=5,
dropout=c(1,0.05,0.05),dqol=2)

}

