% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankacf.R
\name{rankacf}
\alias{rankacf}
\title{Estimator of Spearman autocorrelations}
\usage{
rankacf(x,lag.max=length(x)-2)
}
\arguments{
\item{x}{numeric input vector.}

\item{lag.max}{maximum lag for which acf is estimated, automatically limited to one less than number of observations, should be positive integer.}
}
\value{
Estimated spearman autocorrelation up to lag.max.
}
\description{
Computes Spearman-autocorrelations when the observations contain \code{NA}s.
If the observations do not contain \code{NA}s, the function is consistent with the function acf applied to ranks.
}
\examples{
x = rnorm(10)
rankacf(x)
acf(rank(x),plot=FALSE,lag.max = length(x)-2)$acf[-1,,1]
}
\keyword{internal}
