% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeCore}
\alias{computeCore}
\title{Compute the core}
\usage{
computeCore(algorithm, method, dist, groups)
}
\arguments{
\item{algorithm}{applied algorithm to find solution with method: currently, only \code{randomDescent} is available}

\item{method}{required method for choosing the entries within the groups: \code{A-NE} (accession nearest entry), \code{E-NE} (entry nearest entry) or \code{E-E} (entry entry)}

\item{dist}{distance matrix, used for distances and implicitly defining the set of entries}

\item{groups}{the initially created subdivision into groups}
}
\description{
The function \code{computeCore} is used internally by
the \code{\link{CoreCollection}} object to compute the core.
}
\details{
The \code{A-NE} method requires the core to minimize the average distance between each accession and
the nearest entry within the core. The \code{E-NE} method requires the core to maximize the
average distance between each core entry and its nearest neighbouring entry within the core.
The \code{E-E} method requires the core to maximize the average distance between all core entries.
}
\keyword{internal}
