% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nlp.R
\name{annotateString}
\alias{annotateString}
\title{Annotate a string of text}
\usage{
annotateString(text, format = c("obj", "xml", "text"), outputFile = NA,
  includeXSL = FALSE)
}
\arguments{
\item{text}{a vector of strings for which an annotation is desired.
Will be collapsed to length 1 using new line characters
prior to the annotation.}

\item{format}{the desired output format. Option \code{obj}, the default,
returns an R object of class \code{annotation} and will
likely be the desired choice for most users. The \code{xml}
and \code{text} exist primarily for subsequently saving
to disk.}

\item{outputFile}{character string indicating where to put the output. If
set to NA, the output will be returned by the function.}

\item{includeXSL}{boolean. Whether the xml style sheet should be included
in the output. Only used if format is \code{xml} and
outputFile is not \code{NA}.}
}
\description{
Runs the CoreNLP annotators over a given string of text. The details
for which annotators to run and how to run them are specified in the
properties file loaded in via the \code{initCoreNLP} function (which
must be run prior to any annotation).
}
\examples{
\dontrun{
initCoreNLP()
sIn <- "Mother died today. Or, maybe, yesterday; I can't be sure."
annoObj <- annotateString(sIn)
}
}

