% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_sim.R
\name{b_sim}
\alias{b_sim}
\title{Simulate coefficients from a GLM by making draws from the multivariate
normal distribution}
\usage{
b_sim(obj, nsim = 1000)
}
\arguments{
\item{obj}{a fitted model object.}

\item{nsim}{number of simulations to draw.}
}
\value{
A data frame of simulated coefficients from \code{obj}.
}
\description{
Simulate coefficients from a GLM by making draws from the multivariate
normal distribution
}
\examples{
library(car)

# Estimate model
m1 <- lm(prestige ~ education + type, data = Prestige)

# Create fitted values
prestige_sims <- b_sim(m1)

}

