/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search.stopcriteria;

import java.util.concurrent.TimeUnit;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.stopcriteria.StopCriterion;

public class MaxRuntime
implements StopCriterion {
    private final long maxRuntime;

    public MaxRuntime(long maxRuntime, TimeUnit timeUnit) {
        this.maxRuntime = timeUnit.toMillis(maxRuntime);
        if (this.maxRuntime <= 0L) {
            throw new IllegalArgumentException("Error while creating stop criterion: maximum runtime should be at least 1 millisecond.");
        }
    }

    @Override
    public boolean searchShouldStop(Search<?> search) {
        return search.getRuntime() >= this.maxRuntime;
    }

    public String toString() {
        return "{max runtime: " + this.maxRuntime + " ms}";
    }
}

