% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{read.autodelim}
\alias{read.autodelim}
\title{Read delimited file.}
\usage{
read.autodelim(file, row.names = 1, check.names = FALSE,
  stringsAsFactors = FALSE, strip.white = TRUE, ...)
}
\arguments{
\item{file}{File path.}

\item{row.names}{a vector of row names.  This can be a vector giving
    the actual row names, or a single number giving the column of the
    table which contains the row names, or character string giving the
    name of the table column containing the row names.

    If there is a header and the first row contains one fewer field than
    the number of columns, the first column in the input is used for the
    row names.  Otherwise if \code{row.names} is missing, the rows are
    numbered.

    Using \code{row.names = NULL} forces row numbering. Missing or
    \code{NULL} \code{row.names} generate row names that are considered
    to be \sQuote{automatic} (and not preserved by \code{\link{as.matrix}}).
  }

\item{check.names}{logical.  If \code{TRUE} then the names of the
    variables in the data frame are checked to ensure that they are
    syntactically valid variable names.  If necessary they are adjusted
    (by \code{\link{make.names}}) so that they are, and also to ensure
    that there are no duplicates.}

\item{stringsAsFactors}{logical: should character vectors be converted
    to factors?  Note that this is overridden by \code{as.is} and
    \code{colClasses}, both of which allow finer control.}

\item{strip.white}{logical. Used only when \code{sep} has
    been specified, and allows the stripping of leading and trailing
    white space from unquoted \code{character} fields (\code{numeric} fields
    are always stripped).  See \code{\link{scan}} for further details
    (including the exact meaning of \sQuote{white space}),
    remembering that the columns may include the row names.}

\item{...}{Further arguments to be passed to  \code{\link{read.delim}}.}
}
\value{
Data frame.
}
\description{
Delegates to \code{\link{read.delim}} where the separator is inferred from the file extension (CSV or TXT).
For CSV files the delimiter is set to \code{","} while for TXT file \code{"\t"} is used. Also sets
some default argument values as used by Core Hunter.
}

