% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_words.r
\name{plot_words}
\alias{plot_words}
\title{Plot a wordcloud with words ordered and coloured according to a dimension (x)}
\usage{
plot_words(x, y = NULL, words, wordfreq = rep(1, length(x)), xlab = "",
  ylab = "", yaxt = "n", scale = 2, random.y = T, xlim = NULL,
  ylim = NULL, ...)
}
\arguments{
\item{x}{The (approximate) x positions of the words}

\item{y}{The (approximate) y positions of the words}

\item{words}{A character vector with the words to plot}

\item{wordfreq}{The frequency of the words, defaulting to 1}

\item{xlab}{Label of the x axis}

\item{ylab}{Label of the y axis}

\item{yaxt}{see \code{par} documentation}

\item{scale}{Maximum size to scale the wordsize}

\item{random.y}{if TRUE, the y position of words is random, otherwise it represents the word frequency.}

\item{xlim}{Starting value of x axis}

\item{ylim}{Starting value of y axis}

\item{...}{additional parameters passed to the plot function}
}
\value{
nothing
}
\description{
Plot a wordcloud with words ordered and coloured according to a dimension (x)
}
\examples{
x = c(-10, -5, 3, 5)
y = c(0, 2, 5, 10)
words = c('words', 'where', 'you', 'like')

\dontrun{
plot_words(x,y,words, c(1,2,3,4))
}
}
