% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{tCorpus$search_features}
\alias{tCorpus$search_features}
\title{Find tokens using a Lucene-like search query}
\arguments{
\item{query}{A character string that is a query. See details for available query operators and modifiers. Can be multiple queries (as a vector), in which case it is recommended to also specifiy the code argument, to label results.}

\item{code}{The code given to the tokens that match the query (usefull when looking for multiple queries). Can also put code label in query with # (see details)}

\item{feature}{The name of the feature column within which to search.}

\item{mode}{There are two modes: "unique_hits" and "features". The "unique_hits" mode prioritizes finding full and unique matches., which is recommended for counting how often a query occurs. However, this also means that some tokens for which the query is satisfied might not assigned a hit_id. The "features" mode, instead, prioritizes finding all tokens, which is recommended for coding coding features (the code_features and search_recode methods always use features mode).}

\item{context_level}{Select whether the queries should occur within while "documents" or specific "sentences".}

\item{keep_longest}{If TRUE, then overlapping in case of overlapping queries strings in unique_hits mode, the query with the most separate terms is kept. For example, in the text "mr. Bob Smith", the query [smith OR "bob smith"] would match "Bob" and "Smith". If keep_longest is FALSE, the match that is used is determined by the order in the query itself. The same query would then match only "Smith".}

\item{as_ascii}{if TRUE, perform search in ascii.}

\item{verbose}{If TRUE, progress messages will be printed}
}
\description{
Search tokens in a tokenlist using Lucene-like queries. For a detailed explanation of the query language, see the details below.


\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).
\preformatted{
search_features(query, code = NA, feature = 'token',
                mode = c('unique_hits','features'), verbose = F)
             }
}
\details{
Brief summary of the query language

The following operators and modifiers are supported:
\itemize{
   \item{The standaard Boolean operators: AND, OR and NOT. As a shorthand, an empty space can be used as an OR statement, so that "this that those" means "this OR that OR those". NOT statements stricly mean AND NOT, so should only be used between terms. If you want to find \emph{everything except} certain terms, you can use * (wildcard for \emph{anything}) like this: "* NOT (this that those)".}
   \item{For complex queries parentheses can (and should) be used. e.g. '(spam AND eggs) NOT (fish and (chips OR albatros))}
   \item{Wildcards ? and *. The questionmark can be used to match 1 unknown character or no character at all, e.g. "?at" would find "cat", "hat" and "at". The asterisk can be used to match any number of unknown characters. Both the asterisk and questionmark can be used at the start, end and within a term.}
   \item{Multitoken strings, or exact strings, can be specified using quotes. e.g. "united states"}
   \item{tokens within a given token distance can be found using quotes plus tilde and a number specifiying the token distance. e.g. "climate chang*"~10}
   \item{Alternatively, angle brackets (<>) can be used instead of quotes, which also enables nesting exact strings in proximity/window search}
   \item{Queries are not case sensitive, but can be made so by adding the ~s flag. e.g. COP~s only finds "COP" in uppercase. The ~s flag can also be used on parentheses or quotes to make all terms within case sensitive, and this can be combined with the token proximity flag. e.g. "Marco Polo"~s10}
   \item{The ~g (ghost) flag can be used to mark a term (or all terms within parentheses/quotes) as a ghost term. This has two effects. Firstly, features that match the query term will not be in the results. This is usefull if a certain term is important for getting reliable search results, but not conceptually relevant. Secondly, ghost terms can be used multiple times, in different query hits (only relevant in unique_hits mode). For example, in the text "A B C", the query 'A~g AND (B C)' will return both B and C as separate hit, whereas 'A AND (B C)' will return A and B as a single hit.}
   \item{A code label can be included at the beginning of a query, followed by a # to start the query (label# query). Note that to search for a hashtag symbol, you need to escape it with \ (double \\ in R character vector)}
   \item{Aside from the feature column (specified with the feature argument) a query can include any column in the token data. To manually select a column, use 'columnname: ' at the start of a query or nested query (i.e. between parentheses or quotes). See examples for clarification.}
   }
}
\examples{
text = c('A B C', 'D E F. G H I', 'A D', 'GGG')
tc = create_tcorpus(text, doc_id = c('a','b','c','d'), split_sentences = TRUE)
tc$tokens

hits = tc$search_features(c('query label# A AND B', 'second query# (A AND Q) OR ("D E") OR I'))
hits          ## print shows number of hits
hits$hits     ## hits is a list, with hits$hits being a data.frame with specific features
summary(hits) ## summary gives hits per query

## sentence level
hits = tc$search_features(c('query label# A AND B', 'second query# (A AND Q) OR ("D E") OR I'),
                          context_level = 'sentence')
hits$hits     ## hits is a list, with hits$hits being a data.frame with specific features


## query language examples

\donttest{

## single term
tc$search_features('A')$hits

tc$search_features('G*')$hits    ## wildcard *
tc$search_features('*G')$hits    ## wildcard *
tc$search_features('G*G')$hits   ## wildcard *

tc$search_features('G?G')$hits   ## wildcard ?
tc$search_features('G?')$hits    ## wildcard ? (no hits)

## boolean
tc$search_features('A AND B')$hits
tc$search_features('A AND D')$hits
tc$search_features('A AND (B OR D)')$hits

tc$search_features('A NOT B')$hits
tc$search_features('A NOT (B OR D)')$hits


## sequence search (adjacent words)
tc$search_features('"A B"')$hits
tc$search_features('"A C"')$hits ## no hit, because not adjacent

tc$search_features('"A (B OR D)"')$hits ## can contain nested OR
## cannot contain nested AND or NOT!!

tc$search_features('<A B>')$hits ## can also use <> instead of "".

## proximity search (using ~ flag)
tc$search_features('"A C"~5')$hits ## A AND C within a 5 word window
tc$search_features('"A C"~1')$hits ## no hit, because A and C more than 1 word apart

tc$search_features('"A (B OR D)"~5')$hits ## can contain nested OR
tc$search_features('"A <B C>"~5')$hits    ## can contain nested sequence (must use <>)
tc$search_features('<A <B C>>~5')$hits    ## <> is always OK, but cannot nest "" in ""
## cannot contain nested AND or NOT!!

## case sensitive search (~s flag)
tc$search_features('g')$hits     ## normally case insensitive
tc$search_features('g~s')$hits   ## use ~s flag to make term case sensitive

tc$search_features('(a OR g)~s')$hits   ## use ~s flag on everything between parentheses
tc$search_features('(a OR G)~s')$hits

tc$search_features('"a b"~s')$hits   ## use ~s flag on everything between quotes
tc$search_features('"A B"~s')$hits   ## use ~s flag on everything between quotes

## ghost terms (~g flag)
tc$search_features('A AND B~g')$hits    ## ghost term (~g) has to occur, but is not returned
tc$search_features('A AND Q~g')$hits    ## no hi

# (can also be used on parentheses/quotes/anglebrackets for all nested terms)


## "unique_hits" versus "features" mode
tc = create_tcorpus('A A B')

tc$search_features('A AND B')$hits ## in "unique_hits" (default), only match full queries
# (B is not repeated to find a second match of A AND B)

tc$search_features('A AND B', mode = 'features')$hits ## in "features", match any match
# (note that hit_id in features mode is irrelevant)

# ghost terms (used for conditions) can be repeated
tc$search_features('A AND B~g')$hits

## advanced queries
tc = tokens_to_tcorpus(corenlp_tokens, doc_col = 'doc_id',
                       sentence_col = 'sentence', token_id_col = 'id')
head(tc$tokens) ## search in multiple feature columns with "columnname: "

## using the sub/flag query to find only mary as a direct object
hits = tc$search_features('mary~{relation: dobj}', context_level = 'sentence')
hits$hits

## add a second sub query
hits = tc$search_features('mary~{relation: dobj, parent: 12 20}', context_level = 'sentence')
hits$hits

## selecting from a different column without changing the feature column
## (can be used to combine columns)
hits = tc$search_features('relation: nsubj')
hits$hits

hits = tc$search_features('(relation: nsubj) AND mary~g{relation: dobj}',
                          context_level = 'sentence')
hits$hits

## sequence: nsubj say*
hits = tc$search_features('"(relation: nsubj) say*"')
hits$hits
}
}
