% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_tcorpus.r
\name{refresh_tcorpus}
\alias{refresh_tcorpus}
\title{Refresh a tCorpus object using the current version of corpustools}
\usage{
refresh_tcorpus(tc)
}
\arguments{
\item{tc}{a tCorpus object}
}
\value{
a tCorpus object
}
\description{
As an R6 class, tCorpus contains its methods within the class object (i.e. itself). Therefore, if you use a new version of corpustools with an older tCorpus object (e.g., stored as a .rds. file), then the methods are not automatically updated. You can then use refresh_tcorpus() to reinitialize the tCorpus object with the current version of corpustools.
}
\examples{
tc = create_tcorpus(c('First text', 'Second text'))
refresh_tcorpus(tc)
}
