% Generated by roxygen2 (4.0.2): do not edit by hand
\name{corregp}
\alias{corregp}
\title{Correspondence Regression}
\usage{
corregp(formula, data, part = NULL, b = 0, xep = TRUE, std = FALSE,
  rel = TRUE, phi = FALSE, chr = ".")
}
\arguments{
\item{formula}{A \code{\link[stats]{formula}} specification of which factors to cross with each other. The left-hand (\code{y}) side must be a single factor.
The right-hand side (\code{x}) can involve all the usual specifications of interactions and/or nested analyses.}

\item{data}{The data frame containing the variables specified in the \code{formula}.}

\item{part}{The name of a factor partitioning the levels of the left-hand side \code{y} into groups.
This argument is relevant for analyses in which one wants to remove between-item variation.}

\item{b}{Number of the bootstrap replications. If \code{0} (i.e. the default), then the analysis is exploratory.}

\item{xep}{Logical specifying whether to output the separate terms in the right-hand side (\code{x}) as components in a list.
If \code{FALSE}, then all \code{x} output is collected in a matrix.}

\item{std}{Logical specifying whether to output the standardized coordinates. Defaults to \code{FALSE}.}

\item{rel}{Logical specifying whether to divide the coordinates by the \code{sqrt} of their totals, so that one obtains coordinates for
the relative frequencies (as is customary in correspondence analysis). Defaults to \code{TRUE}.}

\item{phi}{Logical specifying whether to compute the output on the scale of the \emph{Chi-squared} value of the contingency table or of the \emph{Phi-squared} value
(which is \emph{Chi-squared} divided by \emph{N}). Reminiscent of \code{\link[MASS]{corresp}} in package \pkg{MASS}, defaults to \code{FALSE}.}

\item{chr}{Character specifying the separator string for constructing the interaction terms.}
}
\value{
An object of class "corregp", i.e. a list with components:
\item{\code{eigen} }{A vector of eigenvalues of the correpondence regression.}
\item{\code{y} }{The coordinates (matrix) of the Y levels.}
\item{\code{x} }{The coordinates of the X levels. If \code{xep} is \code{TRUE}, then this is a list with a component for each term name.}
\item{\code{freq} }{A list of the frequencies of every Y and X level.}
\item{\code{conf} }{If \eqn{b>0}. A list of bootstrap replicates for the eigenvalues, the Y levels and the X levels.}
\item{\code{aux} }{A list of auxiliary information (such as the U and V matrices of the SVD, the specified values for all the arguments) to be passed to other functions and methods.}
}
\description{
This is the basic function for \emph{correspondence regression}, i.e. the correspondence analysis of a contingency table formed
  by the categorical variables Y and X, where X can be in turn made up of the combinations of various categorical variables.
}
\details{
Correspondence regression rests on the idea, described by Van der Heijden et al. (1989) and quoted in Greenacre (2007: 272), of using correspondence analysis to inspect
  the interactions in a log-linear analysis.  More specifically, as log-linear analysis or Poisson regression is sometimes used to model a polytomous or multinomial response
  variable (in a GLM), correspondence regression enables the analysis of a categorical factor (\code{Y}) in terms of other (possibly interacting) factors (\code{X}).  These
  are specified in the argument \code{formula}, which can be constructed in all the usual ways of specifying a model formula: e.g. \code{Y ~ X1 * X2} as a shorthand for
  \code{Y ~ X1 + X2 + X1 : X2}, or \code{Y ~ X1 * X2 - X1 : X2}, \code{Y ~ (X1 + X2 + X3) ^ 2}, etc.  Correspondence regression then crosstabulates the \code{Y} factor with all the
  combinations in \code{X}, thus producing a typical contingency table, on which a simple correspondence analysis is performed (see Greenacre 2007: 121-128 for the outline of
  this approach). The more general effects in \code{X} are obtained by aggregating the combinations.

Correspondence regression also allows for inferential validation of the effects, which is done by means of the bootstrap. Setting the argument \code{b} to a number \eqn{> 0}, \code{b}
  replicates of the contingency table are generated with multinomial sampling. From these, \code{b} new values are derived for the coordinates in both \code{Y} and
  \code{X} as well as for the eigenvalues (also called the "principal inertias").  On the basis of the replicate values, confidence intervals, ellipses or ellipsoids can
  be computed.  CAUTION: bootstrapping is computationally quite intensive, so it can take a while to reach results, especially with a large \code{b}.

The argument \code{parm} can be used when the levels of \code{Y} are grouped/partitioned/nested into clusters and one wants to exclude the heterogeneity between the clusters.  Thus,
  \code{parm} is equivalent to a \emph{random factor}, although \code{corregp} currently allows for only one such factor.  The use of \code{parm} can be relevant for so-called
  \emph{lectometric} analyses in linguistics.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
haireye.crg
}
\references{
Greenacre, M. (2007) \emph{Correspondence analysis in practice, Second edition}. Boca Raton: Chapman and Hall/CRC.

Van der Heijden, P.G.M., A. de Falguerolles and J. de Leeuw (1989) A combined approach to contingency table analysis using correspondence analysis and log-linear analysis.
  \emph{Applied Statistics} \strong{38} (2), 249--292.
}
\seealso{
\code{\link{print.corregp}}, \code{\link{summary.corregp}}, \code{\link{screeplot.corregp}}, \code{\link{plot.corregp}}.
}

