% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{corregp}
\alias{corregp}
\title{Correspondence Regression}
\usage{
corregp(formula, data, part = NULL, b = 0, xep = TRUE, std = FALSE,
  rel = TRUE, phi = FALSE, chr = ".")
}
\arguments{
\item{formula}{A \code{\link[stats]{formula}} specification of which factors to cross with each other. The left-hand (\code{y}) side must be a single factor.
The right-hand side (\code{x}) can involve all the usual specifications of interactions and/or nested analyses.}

\item{data}{The data frame containing the variables specified in the \code{formula}.}

\item{part}{Character vector specifying the names of conditional factors (e.g. a factor partioning the levels of the left-hand side \code{y} into groups).
This argument is relevant for analyses in which one wants to remove between-item variation.}

\item{b}{Number of the bootstrap replications (simulations). If \code{0} (i.e. the default), then the analysis is exploratory.}

\item{xep}{Logical specifying whether to output the separate terms in the right-hand side (\code{x}) as components in a list.
If \code{FALSE}, then all \code{x} output is collected in a matrix.}

\item{std}{Logical specifying whether to output the standardized coordinates. Defaults to \code{FALSE}.}

\item{rel}{Logical specifying whether to divide the coordinates by the \code{sqrt} of their totals, so that one obtains coordinates for
the relative frequencies (as is customary in correspondence analysis). Defaults to \code{TRUE}.}

\item{phi}{Logical specifying whether to compute the output on the scale of the \emph{Chi-squared} value of the contingency table or of the \emph{Phi-squared} value
(which is \emph{Chi-squared} divided by \emph{N}). Reminiscent of \code{\link[MASS]{corresp}} in package \pkg{MASS}, defaults to \code{FALSE}.}

\item{chr}{Character specifying the separator string for constructing the interaction terms.}
}
\value{
An object of class "corregp", i.e. a list with components:
\item{\code{eigen} }{A vector of eigenvalues of the correpondence regression.}
\item{\code{y} }{The coordinates (matrix) of the Y levels.}
\item{\code{x} }{The coordinates of the X levels. If \code{xep} is \code{TRUE}, then this is a list with a component for each term name.}
\item{\code{freq} }{A list of the frequencies of every Y and X level.}
\item{\code{conf} }{If \eqn{b>0}. A list of bootstrap replicates for the eigenvalues, the coordinates of Y levels, the coordinates of X levels and the frequencies of both the Y levels and the X levels.}
\item{\code{aux} }{A list of auxiliary information (such as the U and V matrices of the SVD, the specified values for all the arguments) to be passed to other functions and methods.}
}
\description{
This is the basic function for \emph{correspondence regression}, i.e. the correspondence analysis of a contingency table formed
  by the categorical variables Y and X, where X can be in turn made up of the combinations of various categorical variables.
}
\details{
Correspondence regression rests on the idea, described by Gilula and Haberman (1988), of using a correspondence analysis to model a polytomous or multinomial (i.e.
  'multi-category') response variable (\code{Y}) in terms of other (possibly interacting) factors (\code{X}) (see also 3.2 in Van der Heijden et al. 1989). These are
  specified in the argument \code{formula}, which can be constructed in all the usual ways of specifying a model formula: e.g.
\itemize{
  \item \code{Y ~ X1 + X2 + X1 : X2} or \code{Y ~ X1 * X2}
  \item \code{Y ~ (X1 + X2 + X3) ^ 2}
  \item \code{Y ~ X1 * X2 * X3 - X1 : X2 : X3}
  \item \ldots
}
Correspondence regression then crosstabulates the \code{Y} factor with all the combinations in \code{X}, thus producing a typical contingency table, on which a simple
  correspondence analysis is performed (see Greenacre 2017: 121-128 for the outline of this approach). The more general effects in \code{X} are obtained by aggregating
  the combinations.  

Correspondence regression also allows for inferential validation of the effects, which is done by means of the bootstrap (in fact, Monte Carlo simulation). Setting the argument
  \code{b} to a number \eqn{> 0}, \code{b} replicates of the contingency table are generated with multinomial sampling. From these, \code{b} new values are derived for the
  coordinates in both \code{Y} and \code{X} as well as for the eigenvalues (also called the "principal inertias").  On the basis of the replicate/simulated values,
  confidence intervals, ellipses or ellipsoids can be computed.  CAUTION: bootstrapping/simulation is computationally quite intensive, so it can take a while to reach
  results, especially with a large \code{b}.  

The argument \code{parm} can be used when one wants to perform a correspondence regression of \code{Y} onto \code{X} conditional on other factors. These conditioning factors are
  therefore equivalent to \emph{random factors}, and \code{corregp} always conditions on the joint variable of all the specified factors. One such use of conditioning factors is
  a so-called \emph{lectometric} analysis in linguistics, where the levels of \code{Y} are grouped/partitioned/nested into clusters and one wants to exclude the heterogeneity
  between the clusters.
}
\examples{
\dontrun{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
haireye.crg
}
}
\references{
Gilula, Z. and S.J. Haberman (1988) The analysis of multivariate contingency tables by restricted canonical and restricted association models.
  \emph{Journal of the American Statistical Association} \strong{83} (403), 760--771.

Greenacre, M. (2017) \emph{Correspondence analysis in practice, Third edition}. Boca Raton: Chapman and Hall/CRC.

Van der Heijden, P.G.M., A. de Falguerolles and J. de Leeuw (1989) A combined approach to contingency table analysis using correspondence analysis and log-linear analysis.
  \emph{Applied Statistics} \strong{38} (2), 249--292.
}
\seealso{
\code{\link{print.corregp}}, \code{\link{summary.corregp}}, \code{\link{screeplot.corregp}}, \code{\link{anova.corregp}}, \code{\link{plot.corregp}}.
}
