% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{print.summary.corregp}
\alias{print.summary.corregp}
\title{Printing the Summary of Correspondence Regression}
\usage{
\method{print}{summary.corregp}(x, ...)
}
\arguments{
\item{x}{The output of a call to \code{summary} on a "corregp" object (i.e. an object of class "summary.corregp").}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The output of a call to \code{summary} on a "corregp" object. The eigenvalues and contributions are printed with \code{TOTAL}s.
}
\description{
Method to print the output of \code{\link{summary.corregp}}.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
summary(haireye.crg, add_ci = TRUE)
summary(haireye.crg, parm = "y", contrib = "pts_axs", nf = 2)
}
}
\seealso{
\code{\link{summary.corregp}}.
}
