% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbCopula.R
\name{cbCopula-Class}
\alias{cbCopula-Class}
\alias{cbCopula}
\title{Checkerboard copulas}
\usage{
cbCopula(x, m = rep(nrow(x), ncol(x)), pseudo = FALSE)
}
\arguments{
\item{x}{the data to be used}

\item{m}{checkerboard parameters}

\item{pseudo}{Boolean, defaults to \code{FALSE}. Set to \code{TRUE} if you are already
providing pseudo data into the \code{x} argument.}
}
\value{
a cbCopula object
}
\description{
cbCopula contructor
}
\details{
The cbCopula class computes a checkerboard copula with a given checkerboard parameter \eqn{m}, as described by A. Cuberos, E. Masiello and V. Maume-Deschamps (2019).
Assymptotics for this model are given by C. Genest, J. Neslehova and R. bruno (2017). The construction of this copula model is as follows :

Start from a dataset with \eqn{n} i.i.d observation of a \eqn{d}-dimensional copula (or pseudo-observations), and a checkerboard parameter \eqn{m},dividing \eqn{n}.

Consider the ensemble of multi-indexes \eqn{I = \{i = (i_1,..,i_d) \subset \{1,...,m \}^d\}} which indexes the boxes :

\deqn{B_{i} = \left]\frac{i-1}{m},\frac{i}{m}\right]}

Let now \eqn{\lambda} be the dimension-unspecific lebesgue measure on any power of \eqn{R}, that is :

\deqn{\forall d \in N, \forall x,y \in R^p, \lambda(\left(x,y\right)) = \prod\limits_{p=1}^{d} (y_i - x_i)}

Let furthermore \eqn{\mu} and \eqn{\hat{\mu}} be respectively the true copula measure of the sample at hand and the classical Deheuvels empirical copula, that is :
\itemize{
\item For \eqn{n} i.i.d observation of the copula of dimension \eqn{d}, let \eqn{\forall i \in \{1,...,d\}, \, R_i^1,...,R_i^d} be the marginal ranks for the variable \eqn{i}.
\item \eqn{\forall x \in I^d} let \eqn{\hat{\mu}((0,x)) = \frac{1}{n} \sum\limits_{k=1}^n I_{R_1^k\le x_1,...,R_d^k\le x_d}}
}

The checkerboard copula, \eqn{C}, and the empirical checkerboard copula, \eqn{\hat{C}}, are then defined by the following :

\deqn{\forall x \in (0,1)^d, C(x) = \sum\limits_{i\in I} {m^d \mu(B_{i}) \lambda((0,x)\cap B_{i})}}

Where \eqn{m^d = \lambda(B_{i})}.

This copula is a special form of patchwork copulas, see F. Durante, J. Fernández Sánchez and C. Sempi (2013) and F. Durante, J. Fernández Sánchez, J. Quesada-Molina and M. Ubeda-Flores (2015).
The estimator has the good property of always being a copula.

The checkerboard copula is a kind of patchwork copula that only uses independent copula as fill-in, only where there are values on the empirical data provided.
To create such a copula, you should provide data and checkerboard parameters (depending on the dimension of the data).
}
\references{
\insertRef{cuberos2019}{cort}

\insertRef{genest2017}{cort}

\insertRef{durante2013}{cort}

\insertRef{durante2015}{cort}
}
