% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cort.R
\name{Cort-Class}
\alias{Cort-Class}
\alias{Cort}
\title{The Cort estimator}
\usage{
Cort(
  x,
  p_value_for_dim_red = 0.75,
  min_node_size = 1,
  pseudo_data = FALSE,
  number_max_dim = NULL,
  verbose_lvl = 1,
  slsqp_options = NULL,
  osqp_options = NULL,
  N = 999,
  force_grid = FALSE
)
}
\arguments{
\item{x}{The data, must be provided as a matrix with each row as an observation.}

\item{p_value_for_dim_red}{a p_value for the localised dimension reduction test}

\item{min_node_size}{The minimum number of observation avaliable in a leaf to initialise a split.}

\item{pseudo_data}{set to True if you are already providing data on the copula space.}

\item{number_max_dim}{The maximum number of dimension a split occurs in. Defaults to be all of the dimensions.}

\item{verbose_lvl}{numeric. set the verbosity. 0 for no ouptut and bigger you set it the most output you get.}

\item{slsqp_options}{options for nloptr::slsqp to find breakpoints : you can change defaults.}

\item{osqp_options}{options for the weights optimisation. You can pass a call to osqp::osqpSettings, or NULL for defaults.}

\item{N}{The number of bootstrap resamples for p_values computations.}

\item{force_grid}{boolean. set to TRUE to force breakpoint to be on the n-checkerboard grid.}
}
\value{
a Cort object that can be fitted easily to produce a copula estimate.
}
\description{
Cort class
}
\details{
This class implements the CORT algorithm to a fit a multivariate copula using piece constant density. See O. Laverny, V. Maume-Deschamps, E. Masiello and D. Rullière (2020) for the details of this density estimation procedure.
}
\examples{
(Cort(LifeCycleSavings[,1:3]))
}
\references{
\insertRef{laverny2020}{cort}
}
