% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corto.R
\name{corto}
\alias{corto}
\title{Calculate a regulon from a data matrix}
\usage{
corto(inmat, centroids, nbootstraps = 100, p = 1e-30, nthreads = 1,
  verbose = FALSE, cnvmat = NULL)
}
\arguments{
\item{inmat}{Input matrix, with features (e.g. genes) as rows and samples
as columns}

\item{centroids}{A character vector indicating which features (e.g. genes)
to consider as centroids (a.k.a. Master Regulators) for DPI}

\item{nbootstraps}{Number of bootstraps to be performed. Default is 100}

\item{p}{The p-value threshold for correlation significance (by default 1E-30)}

\item{nthreads}{The number of threads to use for bootstrapping. Default is 1}

\item{verbose}{Logical. Whether to print progress messages. Default is FALSE}

\item{cnvmat}{An optional matrix with copy-number variation data. If specified, the program
will calculate linear regression between the gene expression data in the input matrix (exp)
and the cnv data, and target profiles will be transformed to the residuals
of each linear model exp~cnv. Default is NULL}
}
\value{
A list (object of class regulon), where each element is a centroid
\itemize{
  \item tfmode: a named vector containing correlation coefficients between
  features and the centroid
  \item likelihood: a numeric vector indicating the likelihood of interaction
}
}
\description{
This function applies Spearman Correlation and DPI to generate a robust
regulon object based on the input data matrix and the selected centroids.
}
\examples{
# Load data matrix inmat (from TCGA mesothelioma project)
load(system.file("extdata","inmat.rda",package="corto",mustWork=TRUE))
# Load centroids
load(system.file("extdata","centroids.rda",package="corto",mustWork=TRUE))
# Run corto
regulon <- corto(inmat,centroids=centroids,nthreads=2,nbootstraps=10,verbose=TRUE)

# In a second example, a CNV matrix is provided. The analysis will be run only
# for the features (rows) and samples (columns) present in both matrices
load(system.file("extdata","cnvmat.rda",package="corto",mustWork=TRUE))
regulon <- corto(inmat,centroids=centroids,nthreads=2,nbootstraps=6,verbose=TRUE,cnvmat=cnvmat,
p=1e-8)
}
