% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{population.cosinor.lm}
\alias{population.cosinor.lm}
\title{Population-Mean Cosinor}
\usage{
population.cosinor.lm(data, time, period, na.action = na.omit,
  alpha = 0.05, plot = T)
}
\arguments{
\item{data}{A data frame containing responses of subjects collected over time, with subjects in the rows and timepoints in the columns.}

\item{time}{A vector containing the times at which the data was collected.}

\item{period}{Duration of one cycle of rhythm.}

\item{na.action}{Action to be performed on missing values. Defaults to \code{na.omit}.}

\item{alpha}{Significance level for calculating population cosinor parameters confidence intervals. Defaults to .05 (confidence intervals are 5\% risk intervals).}

\item{plot}{Logical, display plot after calculation? Defaults to \code{TRUE}.}
}
\value{
Object of the \code{population.cosinor.lm} class containing the following objects:
 \item{\code{single.cos}}{A list of objects containing all performed single cosinors.}
 \item{\code{pop.mat}}{A data frame containing the cosinor parameters of each subject in the population.}
 \item{\code{coefficients}}{Delinearized population-mean cosinor coefficients.}
 \item{\code{emp.mean}}{Empirical mean of the data across all timepoints.}
 \item{\code{fitted.values}}{Estimated values of the rhythm caclculated using the cosinor model.}
 \item{\code{residuals}}{The difference between empirical mean and the fitted values.}
 \item{\code{conf.int}}{Values of upper and lower limits of confidence intervals of delinearized cosinor parameters.}
}
\description{
Calculates the population-mean cosinor.
}
\details{
According to the procedure described in Cornélissen (2014), to calculate population-mean cosinor, single cosinors are first performed on each subject and linearized parameters are averaged, which allows for calculation of delinearized parameters. After such a procedure is completed, confidence intervals of population-mean cosinor parameters can be calculated as described in Bingham et al. (1982) using the following formulae:
\deqn{\widehat{M} \pm \frac{t_{1-\frac{\alpha}{2}}\widehat{\sigma}_M}{\sqrt{k}}}
\deqn{\widehat{\phi}+arctan(\frac{c_{23} t_{1-\frac{\alpha}{2}}^2 \pm t_{1-\frac{\alpha}{2}}\sqrt{c_{33}} \sqrt{\widehat{A}^2-\frac{(c_{22}c_{33}-c_{23}^2)t_{1-\frac{\alpha}{2}}^2}{c_{33}}}}{\widehat{A}^2 - c_{22} t_{1-\frac{\alpha}{2}}^2})}
\deqn{\widehat{A} \pm t_{1-\frac{\alpha}{2}} \sqrt{c_{22}}}
where \eqn{c_{22}}, \eqn{c_{23}} and \eqn{c_{33}} are elements of the sampling scheme matrix, calculated as follows:
\deqn{c_{22}=\frac{\widehat{\sigma}^2_{\beta}\widehat{\beta}^2+2\widehat{\sigma}_{\beta \gamma}\widehat{\beta}\widehat{\gamma}+\widehat{\sigma}^2_{\gamma}\widehat{\gamma}^2}{k\widehat{A}^2}}
\deqn{c_{23}=\frac{-(\widehat{\sigma}^2_{\beta}-\widehat{\sigma}^2_{\gamma})(\widehat{\beta}\widehat{\gamma})+\widehat{\sigma}_{\beta \gamma}(\widehat{\beta}^2-\widehat{\gamma}^2)}{k\widehat{A}^2}}
\deqn{c_{33}=\frac{\widehat{\sigma}^2_{\beta}\widehat{\gamma}^2-2\widehat{\sigma}_{\beta \gamma}\widehat{\beta}\widehat{\gamma}+\widehat{\sigma}^2_{\gamma}\widehat{\beta}^2}{k\widehat{A}^2}}
where \eqn{\widehat{M}}, \eqn{\widehat{A}}, \eqn{\widehat{\phi}}, \eqn{\widehat{\beta}} and \eqn{\widehat{\gamma}} are population-mean cosinor parameters, \eqn{\widehat{\sigma}_M}, \eqn{\widehat{\sigma}_{\beta}} and \eqn{\widehat{\sigma}_{\gamma}} are the standard deviations of the single cosinor parameters, \eqn{\widehat{\sigma}_{\beta \gamma}} is the covariance of the single cosinor \eqn{\beta} and \eqn{\gamma} coefficients, \eqn{k} is the number of subjects in a population and \eqn{t_{1-\frac{\alpha}{2}}} is the two-tailed inverse of the t-distribution with \eqn{\alpha} level of significance and \eqn{k - 1} degrees of freedom.
}
\note{
If the confidence interval of the population amplitude includes zero, confidence interval of the acrophase cannot be calculated reliably. If this case occurs while using this function, the user will be warned and acrophase confidence interval limits will be set to NA.
}
\examples{
population.cosinor.lm(data = PANAS_november, time = PANAS_time,
period = 7, na.action = "na.exclude")
}
\references{
Cornélissen, G. (2014). Cosinor-Based Rhythmometry. \emph{Theoretical Biology and Medical Modeling}, \emph{11}, Article 16.

Bingham, C., Arbogast, B., Guillaume Cornélissen, G., Lee, J.K. & Halberg, F. (1982). Inferential Statistical Methods for Estimating and Comparing Cosinor Parameters. \emph{Chronobiologia}, \emph{9(4)}, 397-439.
}
