% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rovr.R
\name{regression.one.vs.rest}
\alias{regression.one.vs.rest}
\title{Regression One-Vs-Rest}
\usage{
regression.one.vs.rest(X, C, regressor, nthreads = 1, ...)
}
\arguments{
\item{X}{The data (covariates/features).}

\item{C}{matrix(n_samples, n_classes) Costs for each class for each observation.}

\item{regressor}{function(X, y, ...) -> object, that would create regressor with method `predict`.}

\item{nthreads}{Number of parallel threads to use (not available on Windows systems). Note
that, unlike the Python version, this is not a shared memory model and each additional thread will
require more memory from the system. Not recommended to use when the algorithm is itself parallelized.}

\item{...}{Extra arguments to pass to `regressor`.}
}
\description{
Creates a cost-sensitive classifier by creating one regressor per
class to predict cost. Takes as input a regressor rather than a classifier.
The objective is to create a model that would predict the
class with the minimum cost.
}
\examples{
\dontrun{
library(costsensitive)
wrapped.lm <- function(X, y, ...) {
	return(lm(y ~ ., data = X, ...))
}
set.seed(1)
X <- data.frame(feature1 = rnorm(100), feature2 = rnorm(100), feature3 = runif(100))
C <- data.frame(cost1 = rgamma(100, 1), cost2 = rgamma(100, 1), cost3 = rgamma(100, 1))
model <- regression.one.vs.rest(X, C, wrapped.lm)
predict(model, X, type = "class")
predict(model, X, type = "score")
print(model)
}
}
\references{
Beygelzimer, A., Langford, J., & Zadrozny, B. (2008). Machine learning techniques-reductions between prediction quality metrics.
}
