% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_cluster.R
\name{PlotEmbedding}
\alias{PlotEmbedding}
\title{Plot cells using spectral embedding of dot products.}
\usage{
PlotEmbedding(C, colors = color_palette)
}
\arguments{
\item{C}{countland object}

\item{colors}{color palette for ggplot2, default=palette of 11 colors}
}
\value{
generates plot of cells in two spectral embedding dimensions
}
\description{
Plot cells using spectral embedding of dot products.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- Dot(C)
C <- Embed(C,n_components=5)
C <- Cluster(C,n_clusters=3)
PlotEmbedding(C)
}
