% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_local_time.R
\name{calc_local_time}
\alias{calc_local_time}
\title{Calculate local time from UTC for US counties}
\usage{
calc_local_time(date_time, fips, include_tz = TRUE)
}
\arguments{
\item{date_time}{The vector of the date-time of each observation in
Coordinated Universal Time (UTC). This vector can either have a
\code{POSIXct} class or be a character string, with date-time given
as four-digit year, two-digit month, two-digit day, two-digit hour,
and two-digit minutes (with hours based on a 24-hour system). Examples
of acceptable formats include, for the example of 1:00 PM Jan. 2 1999,
"199901021300", "1999-01-02 13:00", and "1999/01/02 13:00".}

\item{fips}{A character vector giving the 5-digit FIPS code of the county
associated with each observation. This can be either a string of length 1,
if all observations come from the same county, or a vector as long as the
\code{date_time} vector, if different observations come from different
counties.}

\item{include_tz}{A TRUE / FALSE value specifying whether to include a
column with the local time zone (\code{local_tz}) in the final output.}
}
\value{
This function returns a dataframe with columns for local date-time,
   local date, and, if specified, local time zone.
}
\description{
This function inputs date-time values in Coordinated Universal Time (UTC;
also known as Zulu Time), along with a vector with county Federal Information
Processing Standard (FIPS) codes, and calculates the local date-time as
well as the local date based on th UTC date-time.
}
\details{
This function inputs date-time values in Coordinated Universal Time (UTC;
also known as Zulu Time), as well as a single value or vector of FIPS code(s) for the
county associated with each observation. It returns a dataframe with
columns for local date-time, local date, and, if specified, local time zone.
}
\note{
The local time is given as a character
   string, rather than a POSIXct object, so that it can have different time
   zones for different counties within the same dataframe (i.e., if there
   are two counties in the dataframe that are in different time zones).
}
\examples{
calc_local_time(date_time = "1999-01-01 08:00", fips = "36061")

ex_datetime <- c("1999-01-01 08:00", "1999-01-01 09:00",
                 "1999-01-01 10:00")
calc_local_time(date_time = ex_datetime, fips = "36061")

ex_datetime <- c("1999-01-01 08:00", "1999-01-01 09:00",
                 "1999-01-01 10:00")
ex_fips <- c("36061", "17031", "06037")
calc_local_time(date_time = ex_datetime, fips = ex_fips)

}

