% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_local_time.R
\name{calc_single_datetime}
\alias{calc_single_datetime}
\title{Convert UTC to local time for a single observation}
\usage{
calc_single_datetime(datetime, tz)
}
\arguments{
\item{datetime}{A POSIXct object of length one expressed in Coordinated
Universal Time (UTC)}

\item{tz}{A character string giving the local time zone based on the
Olson/IANA time zone names}
}
\value{
A character string giving the date-time in the local time zone
}
\description{
This function calculated the local date-time for an observation based on a
date-time in Coordinated Universal Time (UTC). The function provides a
wrapper for the \code{with_tz} function form the \code{lubridate} package.
It converts output from the \code{with_tz} function to a character vector
so other functions in this package can be applied without error to
with a dataframe with observations from multiple time zones to local time.
}
\examples{
utc_time <- as.POSIXct("1999-09-15 14:30:00", tz = "UTC")
local_time <- calc_single_datetime(utc_time, tz = "US/Eastern")

}

