% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_local_time.R
\name{add_local_time}
\alias{add_local_time}
\title{Add local time to dataset}
\usage{
add_local_time(df, fips, datetime_colname, include_tz = TRUE)
}
\arguments{
\item{df}{A dataframe of observations that includes a column with a
date-time object in Coordinated Universal Time (UTC) (see the documentation
for the \code{\link{calc_local_time}} function to see requirements for
the format of this UTC date-time column)}

\item{fips}{A character vector giving the 5-digit FIPS code of the county
associated with each observation. This can be either a string of length 1,
if all observations come from the same county, or a vector as long as the
\code{date_time} vector, if different observations come from different
counties.}

\item{datetime_colname}{A character string giving the column name for the
column that gives date-time in UTC in the input dataframe.}

\item{include_tz}{A TRUE / FALSE value specifying whether to include a
column with the local time zone (\code{local_tz}) in the final output.}
}
\value{
This function returns the dataframe input to the function, with
   columns added with local date-time, local date, and, if specified, local
   time zone.
}
\description{
This function inputs a dataframe of observations for US counties that
includes a column with date-time expressed in Coordinated Universal Time
(UTC), as well as a single value or vector of FIPS code(s) for the
county associated with each observation. It will return the
original dataframe with columns added for local date-time, local date, and,
if specified, local time zone.
}
\examples{
ex_df <- data.frame(datetime = c("1999-01-01 08:00", "1999-01-01 09:00",
                                 "1999-01-01 10:00"),
                    fips = c("36061", "17031", "06037"))
add_local_time(df = ex_df, fips = ex_df$fips,
               datetime_colname = "datetime")

ex_df <- data.frame(datetime = c("1999-01-01 08:00", "1999-01-01 09:00",
                                 "1999-01-01 10:00"))
add_local_time(df = ex_df, fips = "36061", datetime_colname = "datetime")

}

