% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_helpers.R
\name{isd_fips_stations}
\alias{isd_fips_stations}
\title{Get station list for a particular U.S. county.}
\usage{
isd_fips_stations(fips, verbose = FALSE)
}
\arguments{
\item{fips}{A five-digit FIPS county code.}

\item{verbose}{TRUE / FALSE to indicate if you want the function to print
the county or vector of counties it's saving files for as the function runs.}
}
\value{
A list with four elements. The first element, \code{stations}, is a
   dataframe of monitors within a calculated radius of the
   geographic center of the county specified by the FIPS code.
   This will have the same dataframe format as the output from the
   \code{isd_stations_search} function in the \code{rnoaa} package. The
   second element, \code{radius}, gives the radius (in km) within which
   stations were pulled from the county's geographic center.
   Elements \code{lat_center} and \code{lon_center} are the latitude and
   longitude of the county's population-weighted center.
}
\description{
A wrapper to the \code{isd_stations_search} function
in the \code{rnoaa} package, allowing you to search by FIPS code rather than
having to know the latitude and longitude of the center of each county. The
\code{isd_stations_search} function requires a radius within which to search for
stations. This radius is estimated from 2010 U.S. Census Land Area data.
}
\examples{
\dontrun{
fips_list <- isd_fips_stations(fips = "12086")
ids <- fips_list$stations
head(ids)
}
}

